% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscreteDistribution.R
\name{DiscreteDistribution}
\alias{DiscreteDistribution}
\title{Plot distribution of a single discrete numerical variable.}
\usage{
DiscreteDistribution(frm, xvar, title, ..., stem = TRUE, color = "black")
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{numeric: name of the variable whose distribution is to be plotted}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{stem}{if TRUE add whisker/stems to plot}

\item{color}{color of points and stems}
}
\description{
Similar to calling \code{ClevelandDotPlot} with \code{sort = 0} on a numerical x variable that
takes on a discrete set of values.
}
\examples{

frmx = data.frame(x = rbinom(1000, 20, 0.5))
WVPlots::DiscreteDistribution(frmx, "x","Discrete example")

}
