% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.mrt2arm}
\alias{wp.mrt2arm}
\title{Statistical Power Analysis for Multisite Randomized Trials with 2 Arms}
\usage{
wp.mrt2arm(n = NULL, f = NULL, J = NULL, tau00 = NULL, tau11 = NULL,
  sg2 = NULL, power = NULL, alpha = 0.05, alternative = c("two.sided",
  "one.sided"), type = c("main", "site", "variance"), interval = NULL)
}
\arguments{
\item{n}{Sample size. It is the number of individuals within each cluster.}

\item{f}{Effect size. It specifies the main effect of treatment, the mean difference between the treatment clusters/sites and the control clusters/sites. Effect size must be positive.}

\item{J}{Number of clusters / sites. It tells how many clusters are considered in the study design. At least two clusters are required.}

\item{tau00}{Variance of cluster/site means. It is one of the residual variances in the second level. Its value must be positive.}

\item{tau11}{Variance of treatment effects across sites. It is one of the residual variances in the second level. Its value must be positive.}

\item{sg2}{Level-one error Variance. The residual variance in the first level.}

\item{power}{Statistical power.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{alternative}{Type of the alternative hypothesis (\code{"two.sided"} or \code{"one.sided"}). The default is "two.sided". The option "one.sided" can be either "less" or "greater".}

\item{type}{Type of effect (\code{"main"} or \code{"site"} or \code{"variance"}) with "main" as default.
The type "main" tests treatment main effect, no tau00 needed;
Type "site" tests the variance of cluster/site means, no tau11 or f needed;
and Type "variance" tests variance of treatment effects, no tau00 or f needed.}
\item{interval}{A vector containing the end-points of the interval to be searched for the root.}

}
\value{
An object of the power analysis.
}
\description{
Multisite randomized trials (MRT) are a type of multilevel design for the situation when the entire cluster is randomly assigned to either a treatment arm or a control arm \cite{(Liu, 2013)}.
The data from MRT can be analyzed in a two-level hierarchical linear model, where the indicator variable for treatment assignment is included in first level. If a study contains multiple treatments, then multiple indicators will be used.
This function is for designs with 2 arms (i.e., a treatment and a control).
Three types of tests are considered in the function: (1) The "main" type tests treatment main effect;
(2) The "site" type tests the variance of cluster/site means;
and (3) The "variance" type tests variance of treatment effects.
Details leading to power calculation can be found in \cite{Raudenbush (1997)} and \cite{Liu (2013)}.
}
\examples{
#To calculate the statistical power given sample size and effect size:
#For main effect
wp.mrt2arm(n = 45, f = 0.5, J = 20, tau11 = 0.5,
            sg2 = 1.25, alpha = 0.05, power = NULL)
#  Power analysis for Multileve model Multisite randomized trials with 2 arms
#
#      J  n   f tau11  sg2     power alpha
#      20 45 0.5   0.5 1.25 0.8583253  0.05
#
#  NOTE: n is the number of subjects per cluster
#  URL: http://psychstat.org/mrt2arm

#For variance of treament effect
wp.mrt2arm(n = 45, f = 0.5, J = 20, tau11 = 0.5,
               sg2 = 1.25, alpha = 0.05, power = NULL, type = "variance")
#  Power analysis for Multileve model Multisite randomized trials with 2 arms
#
#     J  n   f tau11  sg2     power alpha
#    20 45 0.5   0.5 1.25 0.9987823  0.05
#
#  NOTE: n is the number of subjects per cluster
#  URL: http://psychstat.org/mrt2arm

#For testing site variablity
res<- wp.mrt2arm(n = 45, J = 20, tau00 = 0.5,
                 sg2 = 1.25, alpha = 0.05, power = NULL, type = "site")
#  Power analysis for Multileve model Multisite randomized trials with 2 arms
#
#     J  n tau00  sg2     power alpha
#    20 45   0.5 1.25 0.9999999  0.05
#
#  NOTE: n is the number of subjects per cluster
#  URL: http://psychstat.org/mrt2arm

#To generate a power curve given a sequence of sample sizes:
res <- wp.mrt2arm(n = seq(10,50,5), f = 0.5, J = 20, tau11 = 0.5,
                          sg2 = 1.25, alpha = 0.05, power = NULL)
#  Power analysis for Multileve model Multisite randomized trials with 2 arms
#
#      J  n   f tau11  sg2     power alpha
#     20 10 0.5   0.5 1.25 0.6599499  0.05
#     20 15 0.5   0.5 1.25 0.7383281  0.05
#     20 20 0.5   0.5 1.25 0.7818294  0.05
#     20 25 0.5   0.5 1.25 0.8090084  0.05
#     20 30 0.5   0.5 1.25 0.8274288  0.05
#     20 35 0.5   0.5 1.25 0.8406659  0.05
#     20 40 0.5   0.5 1.25 0.8506049  0.05
#     20 45 0.5   0.5 1.25 0.8583253  0.05
#     20 50 0.5   0.5 1.25 0.8644864  0.05
#
#  NOTE: n is the number of subjects per cluster
#  URL: http://psychstat.org/mrt2arm

#To plot the power curve:
plot(res) 

#To calculate the required sample size given power and effect size:
wp.mrt2arm(n = NULL, f = 0.5, J = 20, tau11 = 0.5,
                      sg2 = 1.25, alpha = 0.05, power = 0.8)
#  Power analysis for Multileve model Multisite randomized trials with 2 arms
#
#     J        n   f tau11  sg2 power alpha
#    20 23.10086 0.5   0.5 1.25   0.8  0.05
#
#  NOTE: n is the number of subjects per cluster
#  URL: http://psychstat.org/mrt2arm
}
\references{
Liu, X. S. (2013). Statistical power analysis for the social and behavioral sciences: basic and advanced techniques. Routledge.

Raudenbush, S. W. (1997). Statistical analysis and optimal design for cluster randomized trials. Psychological Methods, 2(2), 173.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
