% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/whitestripe_ind.R
\name{whitestripe}
\alias{whitestripe}
\title{Performs White Stripe of T1 or T2 Images}
\usage{
whitestripe(img, type = c("T1", "T2", "last", "largest"), breaks = 2000,
  whitestripe.width = 0.05, whitestripe.width.l = whitestripe.width,
  whitestripe.width.u = whitestripe.width, arr.ind = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{img}{Image (T1 or T2).  Array or object of class nifti}

\item{type}{T1 or T2 image whitestripe}

\item{breaks}{Number of breaks passed to \code{\link{hist}}}

\item{whitestripe.width}{Radius of the white stripe}

\item{whitestripe.width.l}{Lower Radius of the white stripe}

\item{whitestripe.width.u}{Upper Radius of the white stripe}

\item{arr.ind}{Whether indices should be array notation or not,
passed to \code{\link{which}}}

\item{verbose}{Print diagnostic information}

\item{...}{Arguments to be passed to \code{\link{get.last.mode}}}
}
\value{
List of indices of whitestripe, last mode of histogram,
array/nifti of 0/1 corresponding to the mask,
mean of whitestripe, standard deviation of whitestripe
}
\description{
Returns the mean/sd of the whitestripe and indices
for them on the image
}
\examples{
\dontrun{
if (download_img_data()){
t1 = readNIfTI(system.file("T1Strip.nii.gz", package="WhiteStripe"))
t1.ind = whitestripe(t1, "T1")
t1.mask = whitestripe_ind_to_mask(t1, t1.ind$whitestripe.ind)
t1.mask[t1.mask == 0] = NA
orthographic(t1, t1.mask, col.y="red")
t2 = readNIfTI(system.file("T2Strip.nii.gz", package="WhiteStripe"))
t2.ind = whitestripe(t2, "T2")
t2.mask = whitestripe_ind_to_mask(t2, t2.ind$whitestripe.ind)
t2.mask[t2.mask == 0] = NA
orthographic(t2, t2.mask, col.y="red")
}
}
}

