% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whitestripe_ind.R
\name{whitestripe_hybrid}
\alias{whitestripe_hybrid}
\alias{hybrid}
\title{Hybrid WhiteStripe}
\usage{
whitestripe_hybrid(t1, t2, ...)
}
\arguments{
\item{t1}{T1 image, array or class nifti}

\item{t2}{T2 image, array or class nifti}

\item{...}{arguments passed to \code{\link{whitestripe}}}
}
\value{
List of indices of overlap mask, and overlap of class array or nifti
}
\description{
Uses t1 and t2 WhiteStripe to get an intersection of
the two masks for a hybrid approach
}
\examples{
\dontrun{
lib.loc = tempdir()
if (download_img_data(lib.loc = lib.loc)){
t1 = readNIfTI(system.file("T1Strip.nii.gz", package="WhiteStripe", 
lib.loc = lib.loc))
t2 = readNIfTI(system.file("T2Strip.nii.gz", package="WhiteStripe",
lib.loc = lib.loc))
ind = whitestripe_hybrid(t1, t2)
}
}
}
\seealso{
whitestripe
}
\keyword{hybrid,}
\keyword{whitestripe}
