% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{simbase}
\alias{simbase}
\alias{ws_t}
\alias{ws_t_tr}
\alias{ws_t_te}
\alias{ws_t_logf}
\alias{ws_t_tr_logf}
\alias{ws_t_te_logf}
\alias{ws_be}
\alias{ws_be_tr}
\alias{ws_be_te}
\alias{ws_be_logf}
\alias{ws_be_tr_logf}
\alias{ws_be_te_logf}
\title{Predefined simbases in WoodSimulatR}
\format{
For statistical simulation of datasets in \code{WoodSimulatR}, one
needs a \code{\link{simbase_covar}} object. \code{WoodSimulatR} contains a
set of such predefined simbases for Norway spruce (\emph{Picea abies}) grown
in Austria.

The names of the simbases follow the following schema -- the different parts
are separated by "_":

\itemize{
\item "ws" -- abbreviation of "\strong{W}oodSimulatR \strong{s}imbase"
\item loadtype -- can either be "t" for material tested in tension,
or "be" for material tested in bending
\item subsample -- empty for the full dataset, "tr" for the part of the
dataset that was used for training, "te" for the part that was used for
testing. The latter two can be used to more closely simulate independent
training and test samples
\item transformation -- empty for no transformation, "logf" if the strength
has been log-transformed prior to calculation of the simbase -- see also
the argument \code{transforms} in \code{\link{simbase_covar}}.
}

The simbases contain the basis for simulating the following variables:
\describe{
\item{f}{Bending or tension strength, in N/mm².}
\item{E}{Static modulus of elasticity in bending or tension, in N/mm².}
\item{rho}{Density of a small clear sample, in kg/m³.}
\item{E_dyn}{Dynamic modulus of elasticity of the timber after drying to a
moisture content of about 12\%, in N/mm².}
\item{E_dyn_u}{Dynamic modulus of elasticity of the timber in the green
state, with moisture contents mostly above fibre saturation point,
in N/mm².}
\item{ip_rho}{An "indicating property" (IP) for density, established by
measuring the weight of each board and dividing by its volume, in kg/m³.}
\item{ip_f}{An "indicating property" (IP) for strength, established by
linear regression on \code{E_dyn}, \code{ip_rho} and a knot parameter
called "total knot area ratio" (tKAR), in N/mm².}
}
}
\source{
The simbases were created based on data from the research project
SiOSiP of Holzforschung Austria. "SiOSiP" is short for "simulation-based
optimization of sawn timber production" and ran from 2014 to 2017.
}
\usage{
ws_t
 ws_t_tr
 ws_t_te
 ws_t_logf
 ws_t_tr_logf
 ws_t_te_logf
 ws_be
 ws_be_tr
 ws_be_te
 ws_be_logf
 ws_be_tr_logf
 ws_be_te_logf
}
\description{
Predefined simbases in WoodSimulatR
}
