% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichD3.r
\name{xEnrichD3}
\alias{xEnrichD3}
\title{Function to visualise enrichment results using a D3 plot}
\usage{
xEnrichD3(
eTerm,
top_num = 10,
FDR.cutoff = 0.05,
type = c("sankey", "force", "radial", "diagonal"),
colormap = "ggplot2",
filename = "xEnrichD3",
...
)
}
\arguments{
\item{eTerm}{an object of class "eTerm" or "ls_eTerm". Alterntively, it
can be a data frame having all these columns (named as
'group','ontology','name','adjp','zscore')}

\item{top_num}{the number of the top terms (sorted according to adjp).
For the eTerm object, if it is 'auto' (for eTerm), only the significant
terms (see below FDR.cutoff) will be displayed}

\item{FDR.cutoff}{FDR cutoff used to declare the significant terms. By
default, it is set to 0.05}

\item{type}{the D3 type of the plot. It can be "sankey" for sankey
network, "force" for force directed network graph, "radial" for radial
network and "diagonal" for diagonal network}

\item{colormap}{short name for the group/ontology colormap}

\item{filename}{the without-extension part of the name of the output
html file. By default, it is 'xEnrichD3'}

\item{...}{additional graphic parameters used in
networkD3::sankeyNetwork, networkD3::forceNetwork,
networkD3::radialNetwork and networkD3::diagonalNetwork}
}
\value{
an object of class "htmlwidget", appended with an "igraph" object
}
\description{
\code{xEnrichD3} is supposed to visualise enrichment results using a D3
plot. It returns an object of class "htmlwidget".
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

res <- xEnrichD3(eTerm, type="sankey", width=500, height=500)
res <- xEnrichD3(eTerm,type="radial", fontSize=12,
nodeColour="steelblue", nodeStroke="fff")
res
res$ig
ig <- xConverter(res$ig, from='igraph', to='igraph_tree')

# BiocManager::install('webshot')
# webshot::install_phantomjs()
# BiocManager::install('r2d3')
# r2d3::save_d3_png(res, file='xEnrichD3.png', zoom=2)
}
}
\seealso{
\code{\link{xEnricherGenes}}, \code{\link{xEnricherSNPs}},
\code{\link{xEnrichViewer}}
}
