\name{YPmodel.lackfittest}
\alias{YPmodel.lackfittest}
\alias{summary.YPmodel.lackfittest}
\alias{plot.YPmodel.martint}
\alias{plot.YPmodel.survf}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Martingale residual-based & contrast-based lack-of-fit tests
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Four functions to perform the two lack-of-fit tests (martingale residual-based & contrast-based), to print results, and to draw randomly selected realizations of the process.
}
\usage{

\method{YPmodel}{lackfittest}(data, repNum, Internal, ...)
\method{summary}{YPmodel.lackfittest}(object, ...)
\method{plot}{YPmodel.martint}(x, Internal, ...)
\method{plot}{YPmodel.survf}(x, Internal, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{\dots}{ For S4 method only. }
  \item{data}{ A properly qualified filename where text data is to be saved, or a dataframe of input data set with three vectors: the event / censoring time (unite: year), the censoring indicator, and the group membership indicator. See the structure of sample data set \code{\link{gastric}} for instance.} 
  \item{repNum}{ Number of times the resampling simulations are done. }
  \item{Internal}{ A dataframe of internal parameters, used only to perform hypothesis tests and plot (and to accelerate the speed). }
  \item{x}{ A dataframe of the two lack-of-fit tests, generated by \code{\link{YPmodel.lackfittest}}. }
  \item{object}{ A dataframe of the two lack-of-fit tests, generated by \code{\link{YPmodel.lackfittest}}, equally to x (different symbol for S4 method only). }
}
\value{
  \item{newBest}{ Value of \eqn{\hat{\beta}} used in the two tests. }
  \item{pvalu1}{ p-value from martingale residual-based test. }
  \item{pvalu2}{ p-value from contrast-based test. }
  \item{mobs1}{ Parameter used in plotting martingale residual-based test. }
  \item{mobs2}{ Parameter used inplotting contrast-based test. }
  \item{obs}{ Parameter used in plotting martingale residual-based test. }
  \item{obs2}{ Parameter used in plotting contrast-based test. }
  \item{wtildCount1}{ Parameter used in plotting martingale residual-based test. }
  \item{lineCount1}{ Parameter used in plotting martingale residual-based test. }
  \item{wtildCount2}{ Parameter used in plotting contrast-based test. }
  \item{lineCount2}{ Parameter used in plotting contrast-based test. }
}


\references{
%% ~put references to the literature/web site here ~
YANG, S. AND ZHAO, Y. (2012). Checking the Short-Term and Long-Term Hazard Ratio Model for Survival Data. Scandinavian Journal of Statistics.  
}
\author{
%%  ~~who you are~~
Junlong Sun and Song Yang
}

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{YPmodel}}, \code{\link{YPmodel.setRandom}}
}
\examples{
    library(YPmodel)
    data(gastric)
    LackFitTest <- YPmodel.lackfittest(data=gastric, repNum=100)
    summary.YPmodel.lackfittest(LackFitTest)
    plot.YPmodel.martint(LackFitTest)
    plot.YPmodel.survf(LackFitTest)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{YPmodel}