% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_period.R
\name{video_time_period}
\alias{video_time_period}
\title{Video Time Period Views}
\usage{
video_time_period(
  videoId = NULL,
  period = "day",
  endDate = as.character(format(Sys.Date(), "\%Y-\%m-01")),
  ...
)
}
\arguments{
\item{videoId}{Required. String. Id of YouTube video.}

\item{period}{Required. Time period to breakdown data by. Supported values are
\code{day} and \code{month}}

\item{endDate}{Required. String. Data returned up until the last day specified,
so for monthly period the end date must end with a day of \code{01}}

\item{...}{Addt. arguments passed to \code{analytics_request}}
}
\value{
data.frame
}
\description{
Returns video views by day or month.
}
\examples{
\dontrun{
video_time_period(videoId = "dQw4w9WgXcQ", period = "month")
} 
}
