% Generated by roxygen2 (4.0.2): do not edit by hand
\name{YplantDay}
\alias{YplantDay}
\alias{YplantDay.plant3d}
\alias{YplantDay.plant3dlist}
\alias{YplantDay.stand3d}
\title{Run a simulation over a day with YplantQMC}
\usage{
YplantDay(x, ...)

\method{YplantDay}{plant3dlist}(x, met, phy = NULL, hemi = NULL, ...)

\method{YplantDay}{stand3d}(x, ...)

\method{YplantDay}{plant3d}(x, met, phy = NULL, hemi = NULL,
  quiet = FALSE, writePSR = TRUE, PSRsuffix = "", writeOUT = FALSE, ...)
}
\arguments{
\item{x}{An object of class 'plant3d' or 'plant3dlist' (see
\code{\link{constructplant}} and \code{\link{readplantlist}}).}

\item{met}{An object of class 'ypmet', see \code{\link{setMet}}}

\item{phy}{An object of class 'ypphy', see \code{\link{setPhy}}}

\item{hemi}{An object of class 'yphemi', see \code{\link{setHemi}}}

\item{quiet}{If TRUE, does not write messages to the console.}

\item{writePSR}{If TRUE, writes a PSR output file.}

\item{PSRsuffix}{A suffix to be added to the PSR files that are written to disk.}

\item{writeOUT}{If TRUE, writes an OUT output file.}

\item{\dots}{Further arguments passed to \code{\link{runYplant}}}
}
\value{
The \code{YplantDay} functions returns a list of class
\code{yplantsim}, which has \code{print} and \code{plot} methods (see
Examples).

The list has the following components:

\describe{
\item{plant}{The plant object used in the simulation}
\item{phy}{If provided, the phy object used in the simulation}
\item{hemi}{If provided, the hemi object used in the simulation}
\item{outdata}{A very lengthy dataframe with all results (see below)}
\item{nsteps}{Number of timesteps}
\item{psrdata}{Totals and
averages by timestep (dataframe), see \code{\link{psrdata}}}
\item{met}{The met object used in the simulation} }

The \code{outdata} dataframe in the \code{yplantsim} object lists results for
individual leaves, has the following variables.

\describe{
\item{timeofday}{Time of day for current timestep (hours)}
\item{leafnr}{Leaf number}
\item{timestep}{Length of current timestep (seconds)}
\item{PAR0}{Above-canopy PAR}
\item{PARleaf}{Total PAR absorption}
\item{PARdir}{Direct solar radiation PAR absorption}
\item{PARdiff}{Diffuse PAR absorption}
\item{reldiff}{Relative diffuse radiation absorption (0-1).}
\item{reldir}{Relative direct radiation absorption (0-1).}
\item{LA}{Individual leaf area (mm2)}
\item{LAproj}{Projected leaf area (mm2)}
\item{LAsunlit}{Sunlit, or 'displayed' leaf area (mm2)}
\item{A}{CO2 assimilation rate (mu mol m-2 s-1)}
\item{E}{Transpiration rate (mmol m-2 s-1)}
\item{gs}{Stomatal conductance (mol m-2 s-1)}
\item{A0}{CO2 assimilation rate for a horizontal unshaded leaf (mu mol m-2 s-1)}
}

Where PAR is photosynthetically active radiation (mu mol m-2 s-1).

The absorptions \code{reldiff} and \code{reldir} are relative to an unshaded
horizontal surface.

To extract relative diffuse radiation absorption from an \code{yplantsim}
object, for example:
\preformatted{
mysim <- YplantDay(myplant, mymet)
reldif<- mysim$outdata$reldiff
}
}
\description{
Interface to daily simulations with YplantQMC. Two objects are required to
run the simulation: a \code{plant3d} object, containing the plant structure
information, and a \code{met} object, containing weather data, solar
position, and number of timesteps.

Optionally, a \code{phy} object is used which contains the leaf gas exchange
model for the simulation, to calculate photosynthesis (and possibly
transpiration rate) from light capture and other weather variables.

Also optional is the use of a \code{hemi} object, which specifies shading by
a canopy.

If you don't know where to start, run the example at the bottom of this page.

See the arguments list above for the functions that are used to generate each
of the four objects. Note that the \code{plant} and \code{met} objects are
required, and \code{phy} and \code{hemi} are optional.

This function is a user-friendly wrapper for \code{\link{runYplant}}. That
function should be used for all advanced simulations.
}
\examples{
\dontrun{
# Set location,
southernfrance <- setLocation(lat=44)

# A daily weather object, use a constant beam fraction of 0.4.
sunnyday <- setMet(southernfrance, month=6, day=21, nsteps=12, Tmin=9, Tmax=29, PARday=22,
	fbeamday=0.4, fbeammethod="constant")

# Light response curve:
toonalrc <- setPhy("lightresponse",
	leafpars=list(Amax=14.5, Rd=1.4, phi=0.05, theta=0.5, reflec=0.1, transmit=0.05))

# Run YplantQMC for a day. Use the built-in 'largegap' hemiphoto.
toonarun <- YplantDay(toona, sunnyday, toonalrc, largegap)
}
}
\author{
Remko Duursma
}
\references{
See \url{http://www.remkoduursma/yplantqmc}
}
\seealso{
\code{\link{runYplant}},\code{\link{ypreport}}
}
\keyword{misc}

