% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_aRchi.R
\name{build_aRchi}
\alias{build_aRchi}
\title{Build a an object of class aRchi}
\usage{
build_aRchi(QSM, point_cloud, keep_original = FALSE)
}
\arguments{
\item{QSM}{A data.table obtained from \code{\link{read_QSM}} function}

\item{point_cloud}{A point cloud. Either a LAS or a data.table with at least three columns with 3d coordinates (i.e X,Y,Z)}

\item{keep_original}{logical (Default = FALSE). Should the original branching order and axis be kept ? Otherwise, it is re-estimated.}
}
\description{
Build an object of class aRchi
}
\examples{
file_QSM=system.file("extdata","Tree_1_TreeQSM.txt",package = "aRchi")
file_pc=system.file("extdata","Tree_1_point_cloud.las",package = "aRchi")
QSM=read_QSM(file_QSM,model="treeQSM")
pc=lidR::readLAS(file_pc)
# Make an object of class aRchi
Tree1_aRchi=build_aRchi(QSM=QSM,point_cloud=pc)
}
\seealso{
\code{\link{aRchi}}; \code{\link{write_aRchi}}; \code{\link{read_aRchi}}
}
