% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPC.R
\name{aSPC}
\alias{aSPC}
\title{An adaptive sum of powered correlation test (aSPC)
for association between two random vectors}
\usage{
aSPC(df1, df2, pow = c(1:6, Inf), B = 100, Z.transform = TRUE,
  method = "pearson")
}
\arguments{
\item{df1, }{first sample matrix}

\item{df2, }{second sample matrix}

\item{pow, }{power integer candidates, default c(1:8, Inf)}

\item{B, }{number of permutations to calculate a P-value. Default is 100.}

\item{Z.transform, }{whether to do Fisher's z-transformation on Pearson correlation, default is TRUE.}

\item{method, }{one of "pearson", "spearman", or "dcor". Default is "pearson".}
}
\value{
the P-values of SPC and aSPC tests
}
\description{
An adaptive sum of powered correlation test (aSPC)
for association between two random vectors
}
\examples{
library(mvtnorm)
sigma = diag(0.9, 10) + 0.1
n = 50 # sample size
Z = rmvnorm(n=n, mean=rep(0,10), sigma=sigma)
X = rmvnorm(n=n, mean=rep(0,15), sigma=diag(1, 15))
Y = rmvnorm(n=n, mean=rep(0,15), sigma=diag(1, 15))
X = as.data.frame(cbind(Z[,1:5], X))
Y = as.data.frame(cbind(Z[,6:10], Y))
set.seed(123) # to ensure we can replicate the permutation P-value
p = 2; q = 2; n=50
X = rmvnorm(n=n, mean=rep(0,p), sigma=diag(1, p))
Y = rmvnorm(n=n, mean=rep(0,q), sigma=diag(1, q))
a = proc.time()
aSPC(X, Y, pow = c(1:8, Inf), B = 1000, method = "pearson")
proc.time() - a

#' a = proc.time()
aSPC(X, Y, pow = c(1:8, Inf), B = 1000, method = "spearman")
proc.time() - a

a = proc.time()
aSPC(X, Y, pow = c(1:8, Inf), B = 500, method = "dcor")
proc.time() - a
}
\references{
Xu Z., Pan W. 2017. Adaptive testing for association between two random vectors in moderate to high dimensions. Submitted to Genetic Epidemiology

Kim J., Zhang Y., Pan W. Powerful and Adaptive Testing for Multi-trait and Multi-SNP Associa-tions with GWAS and Sequencing Data. Genetics, 2016, 203(2): 715-731.
}

