% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_fit.R
\name{fit.abaModel}
\alias{fit.abaModel}
\title{Fit an aba model.}
\usage{
\method{fit}{abaModel}(object, ...)
}
\arguments{
\item{object}{aba model The aba model to be fitted.}

\item{...}{additional parameters.}
}
\value{
abaModel
}
\description{
Calling \code{fit} will trigger the fitting of all statistical models which
have been specified for the model. This will result in fits for each
group - outcome - stat combination.
}
\details{
Note that this function is identical to the generic \code{aba_fit()} function.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

model_spec <- data \%>\% aba_model() \%>\%
  set_groups(everyone()) \%>\%
  set_outcomes(ConvertedToAlzheimers, CSF_ABETA_STATUS_bl) \%>\%
  set_predictors(
    PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl,
    c(PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_stats('glm')

model <- model_spec \%>\% aba_fit()

}
