% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocrFile.R
\name{ocrFile}
\alias{ocrFile}
\title{OCR File}
\usage{
ocrFile(file_path = "", output_dir = "./", exportFormat = c("txt",
  "txtUnstructured", "rtf", "docx", "xlsx", "pptx", "pdfSearchable",
  "pdfTextAndImages", "pdfa", "xml", "xmlForCorrectedImage", "alto"),
  save_to_file = TRUE)
}
\arguments{
\item{file_path}{path to file containing OCR'd text; required}

\item{output_dir}{path to output directory. file_name will be same as input file name (except for the extension)}

\item{exportFormat}{optional, default: txt; 
options: txt, txtUnstructured, rtf, docx, xlsx, pptx, pdfSearchable, pdfTextAndImages, pdfa, xml, xmlForCorrectedImage, alto}

\item{save_to_file}{Required, Boolean, Default is TRUE, but if not, returns result to memory}
}
\value{
path to output file
}
\description{
Want to quick OCR a local file and get the results? Use this function.
}
\examples{
\dontrun{
ocrFile(file_path="path_to_ocr_file", output_dir="path_to_output_dir")
}
}
