% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processImage.R
\name{processImage}
\alias{processImage}
\title{Process Image}
\usage{
processImage(file_path = "", language = "English",
  profile = c("documentConversion", "documentArchiving", "textExtraction",
  "fieldLevelRecognition", "barcodeRecognition"), textType = c("normal",
  "typewriter", "matrix", "index", "ocrA", "ocrB", "e13b", "cmc7", "gothic"),
  imageSource = c("auto", "photo", "scanner"),
  correctOrientation = c("true", "false"), correctSkew = c("true", "false"),
  readBarcodes = c("false", "true"), exportFormat = c("txt",
  "txtUnstructured", "rtf", "docx", "xlsx", "pptx", "pdfSearchable",
  "pdfTextAndImages", "pdfa", "xml", "xmlForCorrectedImage", "alto"),
  description = "", pdfPassword = "", ...)
}
\arguments{
\item{file_path}{path to the document}

\item{language}{optional, default: English}

\item{profile}{String. Optional; default: \code{documentConversion}
Options: \code{documentConversion, documentArchiving, textExtraction, fieldLevelRecognition, barcodeRecognition}}

\item{textType}{String. Optional; default: \code{normal}
Options: \code{normal, typewriter, matrix, index, ocrA,ocrB, e13b,cmc7, gothic}}

\item{imageSource}{String. Optional; default: \code{auto}
Options: \code{auto, photo, scanner}}

\item{correctOrientation}{String. Optional; default: \code{true}. 
Options: \code{true} or \code{false}}

\item{correctSkew}{String. Optional; default: \code{true}.
Options: \code{true} or \code{false}}

\item{readBarcodes}{Optional; 
Options: \code{true} or \code{false}}

\item{exportFormat}{optional, default: \code{txt} 
options: \code{txt, txtUnstructured, rtf, docx, xlsx, pptx, pdfSearchable, pdfTextAndImages, pdfa, xml, xmlForCorrectedImage, alto}}

\item{description}{optional, default: ""}

\item{pdfPassword}{optional, default: NULL}

\item{\dots}{Additional arguments passed to \code{\link{abbyy_POST}}.}
}
\value{
A \code{data.frame} with details of the task associated with the submitted Image
}
\description{
This function processes an image
}
\examples{
\dontrun{
processImage(file_path="file_path", language="English", exportFormat="txtUnstructured")
}
}
\references{
\url{http://ocrsdk.com/documentation/specifications/image-formats/}

\url{http://ocrsdk.com/documentation/apireference/processImage/}
}
