\docType{data}
\name{Earthworms}
\alias{Earthworms}
\title{Earthworm Diversity and Soil Nitrogen Levels}
\format{A data frame with 39 observations on the following 2 variables.
\describe{ \item{worm.species}{a numeric vector}
\item{nitrogen}{a numeric vector} }}
\source{
  Gundale, M.J., W.M. Jolly, and T.H. Deluca. 2005.
  Susceptibility of a northern hardwood forest to exotic
  earthworm invasion. \emph{Conservation Biology} 19:
  1075-1083.
}
\description{
  Number of earthworm species and total nitrogen content in
  the soil in 39 hardwood forest plots.
}
\examples{
data(Earthworms)
str(Earthworms)
xyplot(nitrogen ~ worm.species, Earthworms)
}
\references{
  \url{http://www3.interscience.wiley.com/journal/118701215/abstract}
}
\keyword{datasets}

