% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.abess.R
\name{plot.abess}
\alias{plot.abess}
\title{Creat plot from a fitted "\code{abess}" object}
\usage{
\method{plot}{abess}(
  x,
  type = c("coef", "l2norm", "dev", "dev.ratio", "tune"),
  label = FALSE,
  ...
)
}
\arguments{
\item{x}{A "\code{abess}" object.}

\item{type}{The type of terms to be plot in the y-axis.
One of the following: \code{"coef"} (i.e., coefficients),
\code{"l2norm"} (i.e., L2-norm of coefficients),
\code{"dev"} (i.e., deviance),
and \code{"tune"} (i.e., tuning value).
Default is \code{"coef"}.}

\item{label}{A logical value.
If \code{label = TRUE} (the default),
label the curves with variable sequence numbers.}

\item{...}{Other graphical parameters to plot}
}
\value{
No return value, called for side effects.
}
\description{
Produces a coefficient/deviance/tuning-value plot
for a fitted "abess" object.
}
\note{
If \code{family = "mgaussian"} or \code{family = "multinomial"},
a coefficient plot is produced for
each dimension of multivariate response.
}
\examples{
dataset <- generate.data(100, 20, 3)
abess_fit <- abess(dataset[["x"]], dataset[["y"]])
plot(abess_fit)
plot(abess_fit, type = "l2norm")
plot(abess_fit, type = "dev")
plot(abess_fit, type = "tune")
}
\seealso{
\code{\link{print.abess}},
\code{\link{predict.abess}},
\code{\link{coef.abess}},
\code{\link{extract.abess}},
\code{\link{plot.abess}},
\code{\link{deviance.abess}}.
}
