% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{extractors}
\alias{extractors}
\alias{get_bf}
\alias{get_prior_prob}
\alias{get_post_prob}
\alias{get_post_samples}
\title{Extraction functions for ab objects}
\usage{
get_bf(x, log = FALSE)

get_prior_prob(x)

get_post_prob(x)

get_post_samples(x, hypothesis = "H1")
}
\arguments{
\item{x}{object of class \code{"ab"} as returned from \code{\link{ab_test}}.}

\item{log}{determines whether the log Bayes factors are returned.}

\item{hypothesis}{determines for which hypothesis posterior samples are
returned. Needs to be either "H1", "H+", or "H-" (the default is "H1").}
}
\value{
\code{get_bf} returns the Bayes factors in favor of "H1", "H+", and
  "H-" (compared to H0). \code{get_prior_prob} returns the prior
  probabilities of the hypotheses. \code{get_post_prob} returns the posterior
  probabilities of the hypotheses. \code{get_post_samples} returns posterior
  samples for the specified hypothesis.
}
\description{
Extraction functions for objects returned from the \code{\link{ab_test}}
function.
}
\examples{
# synthetic data
data <- list(y1 = 10, n1 = 28, y2 = 14, n2 = 26)

# Bayesian A/B test with default settings
ab <- ab_test(data = data, posterior = TRUE)

# extract Bayes factors
get_bf(ab)

# extract prior probabilities
get_prior_prob(ab)

# extract posterior probabilities
get_post_prob(ab)

# extract posterior samples for H1
s <- get_post_samples(ab, hypothesis = "H1")
}
