% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDAD.R
\name{SDAD}
\alias{SDAD}
\alias{SDAD.default}
\title{Sparse Discriminant Analysis solved via ADMM}
\usage{
SDAD(x, ...)

\method{SDAD}{default}(
  Xt,
  Yt,
  Om,
  gam,
  lam,
  mu,
  q,
  PGsteps,
  PGtol,
  maxits,
  tol,
  selector = rep(1, dim(Xt)[2]),
  initTheta
)
}
\arguments{
\item{Xt}{n by p data matrix, (not a data frame, but a matrix)}

\item{Yt}{n by K matrix of indicator variables (Yij = 1 if i in class j).
This will later be changed to handle factor variables as well.
Each observation belongs in a single class, so for a given row/observation,
only one element is 1 and the rest is 0.}

\item{Om}{p by p parameter matrix Omega in generalized elastic net penalty.}

\item{gam}{Regularization parameter for elastic net penalty.}

\item{lam}{Regularization parameter for l1 penalty, must be greater than zero.}

\item{mu}{Penalty parameter for augmented Lagrangian term, must be greater than zero.}

\item{q}{Desired number of discriminant vectors.}

\item{PGsteps}{Maximum number if inner proximal gradient algorithm for finding beta.}

\item{PGtol}{Two stopping tolerances for inner ADMM method, first is absolute tolerance, second is relative.}

\item{maxits}{Number of iterations to run}

\item{tol}{Stopping tolerance for proximal gradient algorithm.}

\item{selector}{Vector to choose which parameters in the discriminant vector will be used to calculate the
regularization terms. The size of the vector must be *p* the number of predictors. The
default value is a vector of all ones. This is currently only used for ordinal classification.}

\item{initTheta}{Initial first theta, default value is a vector of ones.}
}
\value{
\code{SDAD} returns an object of \code{\link{class}} "\code{SDAD}" including a list
with the following named components: (More will be added later to handle the predict function)
\describe{
  \item{\code{call}}{The matched call.}
  \item{\code{B}}{p by q matrix of discriminant vectors.}
  \item{\code{Q}}{K by q matrix of scoring vectors.}
  \item{\code{subits}}{Total number of iterations in proximal gradient subroutine.}
  \item{\code{totalits}}{Number coordinate descent iterations for all discriminant vectors}
}

\code{NULL}
}
\description{
Applies alternating direction methods of multipliers algorithm to
the optimal scoring formulation of sparse discriminant analysis proposed
by Clemmensen et al. 2011.
}
\seealso{
\code{SDADcv}, \code{\link{SDAAP}} and \code{\link{SDAP}}
}
\keyword{internal}
