% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrual_linear_model.R
\name{accrual_linear_model}
\alias{accrual_linear_model}
\title{accrual_linear_model}
\usage{
accrual_linear_model(
  accrual_df,
  fill_up = TRUE,
  wfun = function(x) seq(1/nrow(x), 1, by = 1/nrow(x))
)
}
\arguments{
\item{accrual_df}{object of class 'accrual_df' or 'accrual_list' produced by \code{accrual_create_df}.}

\item{fill_up}{whether to fill up days where no recruitment was observed,}

\item{wfun}{function to calculate the weights based on the accrual data frame, default is}
}
\value{
Returns an object of class 'lm' with a weighted linear regression of cumulative accrual on dates.
}
\description{
Creates a weighted linear regression model using an accrual data frame produced by \code{accrual_create_df}.
}
\examples{
\donttest{
set.seed(2020)
enrollment_dates <- as.Date("2018-01-01") + sort(sample(1:30, 50, replace=TRUE))
accrual_df<-accrual_create_df(enrollment_dates)
accrual_linear_model(accrual_df)

#unweighted
accrual_linear_model(accrual_df, wfun=function(x) rep(1,nrow(x)))

#different start and current date
accrual_df<-accrual_create_df(enrollment_dates,start_date=as.Date("2017-12-01"),
    current_date=as.Date("2018-03-01"))
accrual_linear_model(accrual_df)

#accrual_df with by option
set.seed(2020)
centers<-sample(c("Site 1","Site 2","Site 3"),length(enrollment_dates),replace=TRUE)
accrual_df<-accrual_create_df(enrollment_dates,by=centers)
accrual_linear_model(accrual_df)
}
}
