% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiers_delete.R
\name{tiers_delete}
\alias{tiers_delete}
\title{Delete tiers}
\usage{
tiers_delete(x, tierNames, filterTranscriptNames = NULL)
}
\arguments{
\item{x}{Corpus object.}

\item{tierNames}{Character string; names of the tiers to be deleted.}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be modified. If left open, all transcripts will be checked.}
}
\value{
Corpus object.
}
\description{
Deletes tiers in all transcript objects of a corpus.
If only tiers in certain transcripts should be affected set the parameter \code{filterTranscriptNames}. 
In case that you want to select tiers and/or transcripts by using regular expressions use the function \code{act::search_meta} first.
Results  will be reported in \code{@history} of the transcript objects.
}
\examples{
library(act)

# get info about all tiers
all.tiers <- act::info(examplecorpus)$tiers

# tiers 'A' and 'B' occur 6 times in 6 transcripts
all.tiers["A", "tiers.count"]
all.tiers["B", "tiers.count"]

# delete tiers
tierNames <- c("A", "B")
x<- examplecorpus
x <- act::tiers_delete(examplecorpus, tierNames=tierNames)
x@history[length(x@history)]

# tiers 'A' and 'B' do not occur anymore
act::info(x)$tiers$tier.name
}
\seealso{
\link{tiers_add}, \link{tiers_rename}, \link{tiers_convert}, \link{tiers_sort}, \link{helper_tiers_new_table}, \link{helper_tiers_sort_table}
}
