% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code_1_1.r
\name{lincircKern}
\alias{lincircKern}
\title{Linear-circular kernel fit}
\usage{
lincircKern(x, circdat, lindat)
}
\arguments{
\item{x}{Numeric vector of radian values at which to evaluate the distribution.}

\item{circdat}{Numeric vector of radian data matched with \code{lindat}.}

\item{lindat}{Numeric vector of linear data matched with \code{circdat}.}
}
\value{
A numeric vector of fitted \code{lindat} values matched with \code{x}.
}
\description{
Fits a Von Mises kernel distribution describing a linear variable as a function of a circular predictor.
}
\examples{
data(BCIspeed)
i <- BCIspeed$species=="ocelot"
sp <- log(BCIspeed$speed[i])
tm <- BCIspeed$time[i]*2*pi
circseq <- seq(0,2*pi,pi/256)
trend <- lincircKern(circseq, tm, sp)
plot(circseq, trend, type="l")
}
\references{
Xu, H., Nichols, K. & Schoenberg, F.P. (2011) Directional kernel regression for wind and fire data. Forest Science, 57, 343-352.
}

