% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archetypoids_robust.R
\name{archetypoids_robust}
\alias{archetypoids_robust}
\title{Archetypoid algorithm with the robust Frobenius norm}
\usage{
archetypoids_robust(numArchoid, data, huge = 200, ArchObj, prob, aaframe)
}
\arguments{
\item{numArchoid}{Number of archetypoids.}

\item{data}{Data matrix. Each row corresponds to an observation and each column 
corresponds to a variable. All variables are numeric.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{ArchObj}{The list object returned by the 
\code{\link{stepArchetypesRawData_robust}} function.}

\item{prob}{Probability with values in [0,1].}

\item{aaframe}{Boolean value to indicate whether the frame-based (TRUE) 
(Mair et al., 2017) or the classical (FALSE) (Eugster et al., 2009) archetypes 
will be used. The frame-based archetypes are computed with an ancillary python
code available at \url{https://www.uv.es/vivigui/software}.}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item archet_ini: Vector of initial archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item resid: Matrix with the residuals.
}
}
\description{
Robust version of the archetypoid algorithm with the Frobenius form.
}
\examples{
data(mtcars)
data <- mtcars

k <- 3
numRep <- 2
huge <- 200

lass <- stepArchetypesRawData_robust(data = data, numArch = k, 
                                     numRep = numRep, verbose = FALSE, 
                                     saveHistory = FALSE, prob = 0.8)

# Please see do_ada_robust.R for an example with aaframe = TRUE.
res <- archetypoids_robust(k, data, huge, ArchObj = lass, 0.8, FALSE)
str(res)    
res$cases
res$rss                                                           
                 
}
\references{
Eugster, M.J.A. and Leisch, F., From Spider-Man to Hero - Archetypal Analysis in 
R, 2009. Journal of Statistical Software 30(8), 1-23.

Mair, S., Boubekki, A. and Brefeld, U., Frame-based Data Factorizations, 2017.
Proceedings of the 34th International Conference on Machine Learning, 
Sydney, Australia, 1-9.

Vinue, G., (2017). Anthropometry: An R Package for Analysis of Anthropometric Data,
\emph{Journal of Statistical Software} \bold{77(6)}, 1--39
}
\seealso{
\code{\link{archetypoids_norm_frob}}
}
\author{
Guillermo Vinue
}
