% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{get_stagewise_estimators}
\alias{get_stagewise_estimators}
\alias{get_stagewise_estimators,VirtualPointEstimator,ANY-method}
\alias{get_stagewise_estimators,VirtualPValue,ANY-method}
\alias{get_stagewise_estimators,VirtualIntervalEstimator,ANY-method}
\alias{get_stagewise_estimators,PointEstimator,Student-method}
\alias{get_stagewise_estimators,PValue,Student-method}
\alias{get_stagewise_estimators,IntervalEstimator,Student-method}
\alias{get_stagewise_estimators,VirtualPointEstimator,Student-method}
\alias{get_stagewise_estimators,VirtualIntervalEstimator,Student-method}
\alias{get_stagewise_estimators,VirtualPValue,Student-method}
\alias{get_stagewise_estimators,PointEstimator,DataDistribution-method}
\alias{get_stagewise_estimators,PValue,DataDistribution-method}
\alias{get_stagewise_estimators,IntervalEstimator,DataDistribution-method}
\alias{get_stagewise_estimators,AdaptivelyWeightedSampleMean,Normal-method}
\alias{get_stagewise_estimators,MinimizePeakVariance,Normal-method}
\alias{get_stagewise_estimators,BiasReduced,Normal-method}
\alias{get_stagewise_estimators,RaoBlackwell,Normal-method}
\alias{get_stagewise_estimators,PseudoRaoBlackwell,Normal-method}
\alias{get_stagewise_estimators,RepeatedCI,Normal-method}
\alias{get_stagewise_estimators,LinearShiftRepeatedPValue,Normal-method}
\alias{get_stagewise_estimators,MLEOrderingPValue,Normal-method}
\alias{get_stagewise_estimators,LikelihoodRatioOrderingPValue,Normal-method}
\alias{get_stagewise_estimators,ScoreTestOrderingPValue,Normal-method}
\alias{get_stagewise_estimators,StagewiseCombinationFunctionOrderingPValue,Normal-method}
\alias{get_stagewise_estimators,NeymanPearsonOrderingPValue,Normal-method}
\alias{get_stagewise_estimators,StagewiseCombinationFunctionOrderingCI,Normal-method}
\alias{get_stagewise_estimators,MLEOrderingCI,Normal-method}
\alias{get_stagewise_estimators,LikelihoodRatioOrderingCI,Normal-method}
\alias{get_stagewise_estimators,ScoreTestOrderingCI,Normal-method}
\alias{get_stagewise_estimators,NeymanPearsonOrderingCI,Normal-method}
\alias{get_stagewise_estimators,NaiveCI,Normal-method}
\alias{get_stagewise_estimators,MidpointStagewiseCombinationFunctionOrderingCI,Normal-method}
\alias{get_stagewise_estimators,MidpointMLEOrderingCI,Normal-method}
\alias{get_stagewise_estimators,MidpointLikelihoodRatioOrderingCI,Normal-method}
\alias{get_stagewise_estimators,MidpointScoreTestOrderingCI,Normal-method}
\alias{get_stagewise_estimators,MidpointNeymanPearsonOrderingCI,Normal-method}
\alias{get_stagewise_estimators,MedianUnbiasedStagewiseCombinationFunctionOrdering,Normal-method}
\alias{get_stagewise_estimators,MedianUnbiasedMLEOrdering,Normal-method}
\alias{get_stagewise_estimators,MedianUnbiasedLikelihoodRatioOrdering,Normal-method}
\alias{get_stagewise_estimators,MedianUnbiasedScoreTestOrdering,Normal-method}
\alias{get_stagewise_estimators,MedianUnbiasedNeymanPearsonOrdering,Normal-method}
\title{Conditional representations of an estimator or p-value}
\usage{
get_stagewise_estimators(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{VirtualPointEstimator,ANY}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{VirtualPValue,ANY}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{VirtualIntervalEstimator,ANY}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{PointEstimator,Student}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{PValue,Student}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{IntervalEstimator,Student}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{VirtualPointEstimator,Student}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{VirtualIntervalEstimator,Student}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{VirtualPValue,Student}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{PointEstimator,DataDistribution}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{PValue,DataDistribution}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{IntervalEstimator,DataDistribution}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{AdaptivelyWeightedSampleMean,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MinimizePeakVariance,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{BiasReduced,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{RaoBlackwell,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{PseudoRaoBlackwell,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{RepeatedCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{LinearShiftRepeatedPValue,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MLEOrderingPValue,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{LikelihoodRatioOrderingPValue,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{ScoreTestOrderingPValue,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{StagewiseCombinationFunctionOrderingPValue,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{NeymanPearsonOrderingPValue,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{StagewiseCombinationFunctionOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MLEOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{LikelihoodRatioOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{ScoreTestOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{NeymanPearsonOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{NaiveCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MidpointStagewiseCombinationFunctionOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MidpointMLEOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MidpointLikelihoodRatioOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MidpointScoreTestOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MidpointNeymanPearsonOrderingCI,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MedianUnbiasedStagewiseCombinationFunctionOrdering,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MedianUnbiasedMLEOrdering,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MedianUnbiasedLikelihoodRatioOrdering,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MedianUnbiasedScoreTestOrdering,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{get_stagewise_estimators}{MedianUnbiasedNeymanPearsonOrdering,Normal}(
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)
}
\arguments{
\item{estimator}{object of class \code{PointEstimator}, \code{IntervalEstimator} or \code{PValue}.}

\item{data_distribution}{object of class \code{Normal} or \code{Student}.}

\item{use_full_twoarm_sampling_distribution}{logical indicating whether this estimator is intended to be used
with the full sampling distribution in a two-armed trial.}

\item{design}{object of class \code{TwoStageDesign}.}

\item{sigma}{assumed standard deviation.}

\item{exact}{logical indicating usage of exact n2 function.}
}
\value{
a list with the conditional functional representations
(one for each stage where the trial might end) of the estimator or p-value.
}
\description{
This generic determines the functional representations of
point and interval estimators and p-values. The functions are
returned in two parts, one part to calculate the values conditional
on early futility or efficacy stops
(i.e. where no second stage mean and sample size is available),
and one conditional on continuation to the second stage.
}
\examples{
get_stagewise_estimators(
  estimator = SampleMean(),
  data_distribution = Normal(FALSE),
  use_full_twoarm_sampling_distribution = FALSE,
  design = get_example_design(),
  sigma = 1,
  exact = FALSE
)
}
