% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_disposition_status.R
\name{derive_var_disposition_status}
\alias{derive_var_disposition_status}
\title{Derive a Disposition Status at a Specific Timepoint}
\usage{
derive_var_disposition_status(
  dataset,
  dataset_ds,
  new_var,
  status_var,
  format_new_var = format_eoxxstt_default,
  filter_ds,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{Input dataset.}

\item{dataset_ds}{Dataset containing the disposition information (e.g.: ds).

It must contain:
\itemize{
\item \code{STUDYID}, \code{USUBJID},
\item The variable(s) specified in the \code{status_var}
\item The variables used in \code{filter_ds}.
}}

\item{new_var}{Name of the disposition status variable.

A variable name is expected (e.g. \code{EOSSTT}).}

\item{status_var}{The variable used to derive the disposition status.

A variable name is expected (e.g. \code{DSDECOD}).}

\item{format_new_var}{The format used to derive the status.

Default: \code{format_eoxxstt_default()} defined as:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{format_eoxxstt_default <- function(status) \{
  case_when(
    status \%in\% c("SCREEN FAILURE", "SCREENING NOT COMPLETED") ~ "NOT STARTED",
    status == "COMPLETED" ~ "COMPLETED",
    !status \%in\% c("COMPLETED", "SCREEN FAILURE", "SCREENING NOT COMPLETED")
    & !is.na(status) ~ "DISCONTINUED",
    TRUE ~ "ONGOING"
  )
\}
}\if{html}{\out{</div>}}

where \code{status} is the \code{status_var.}}

\item{filter_ds}{Filter condition for the disposition data.

one observation per patient. An error is issued otherwise.

Permitted Values: logical expression.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of expressions where the expressions are symbols as returned by
\code{exprs()} is expected.}
}
\value{
The input dataset with the disposition status (\code{new_var}) added.
\code{new_var} is derived based on the values given in \code{status_var} and according to the format
defined by \code{format_new_var} (e.g. when the default format is used, the function will derive
\code{new_var} as:
"NOT STARTED" if \code{status} is "SCREEN FAILURE" or "SCREENING NOT COMPLETED",
"COMPLETED" if \code{status_var} == "COMPLETED",
"DISCONTINUED" if \code{status} is not in ("COMPLETED","SCREEN FAILURE",
"SCREENING NOT COMPLETED") nor NA,
"ONGOING" otherwise).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, Please define your own function and use that as input for the
\code{cat_fun} argument in \code{derive_var_merged_cat()} instead.

Derive a disposition status from the the relevant records in the disposition domain.
}
\seealso{
Other deprecated: 
\code{\link{derive_param_extreme_event}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()}
}
\concept{deprecated}
\keyword{deprecated}
