% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_base.R
\name{derive_var_base}
\alias{derive_var_base}
\title{Derive Baseline Variables}
\usage{
derive_var_base(
  dataset,
  by_vars,
  source_var = AVAL,
  new_var = BASE,
  filter = ABLFL == "Y"
)
}
\arguments{
\item{dataset}{The input dataset}

\item{by_vars}{Grouping variables uniquely identifying a set
of records for which to calculate \code{new_var}}

\item{source_var}{The column from which to extract the baseline value, e.g. \code{AVAL}}

\item{new_var}{The name of the newly created baseline column, e.g. \code{BASE}}

\item{filter}{The condition used to filter \code{dataset} for baseline records.

By default \code{ABLFL == "Y"}}
}
\value{
A new \code{data.frame} containing all records and variables of the input
dataset plus the \code{new_var} variable
}
\description{
Derive baseline variables, e.g. \code{BASE} or \code{BNRIND}, in a BDS dataset.

\strong{Note:} This is a wrapper function for the more generic \code{derive_vars_merged()}.
}
\details{
For each \code{by_vars} group, the baseline record is identified by the
condition specified in \code{filter} which defaults to \code{ABLFL == "Y"}. Subsequently,
every value of the \code{new_var} variable for the \code{by_vars} group is set to the
value of the \code{source_var} variable of the baseline record. In case there are
multiple baseline records within \code{by_vars} an error is issued.
}
\examples{
library(tibble)

dataset <- tribble(
  ~STUDYID, ~USUBJID,   ~PARAMCD, ~AVAL,   ~AVALC,      ~AVISIT, ~ABLFL,  ~ANRIND,
  "TEST01",  "PAT01",  "PARAM01", 10.12,       NA,   "Baseline",    "Y", "NORMAL",
  "TEST01",  "PAT01",  "PARAM01", 9.700,       NA,      "Day 7",    "N",    "LOW",
  "TEST01",  "PAT01",  "PARAM01", 15.01,       NA,     "Day 14",    "N",   "HIGH",
  "TEST01",  "PAT01",  "PARAM02", 8.350,       NA,   "Baseline",    "Y",    "LOW",
  "TEST01",  "PAT01",  "PARAM02",    NA,       NA,      "Day 7",    "N",       NA,
  "TEST01",  "PAT01",  "PARAM02", 8.350,       NA,     "Day 14",    "N",    "LOW",
  "TEST01",  "PAT01",  "PARAM03",    NA,    "LOW",   "Baseline",    "Y",       NA,
  "TEST01",  "PAT01",  "PARAM03",    NA,    "LOW",      "Day 7",    "N",       NA,
  "TEST01",  "PAT01",  "PARAM03",    NA, "MEDIUM",     "Day 14",    "N",       NA,
  "TEST01",  "PAT01",  "PARAM04",    NA,   "HIGH",   "Baseline",    "Y",       NA,
  "TEST01",  "PAT01",  "PARAM04",    NA,   "HIGH",      "Day 7",    "N",       NA,
  "TEST01",  "PAT01",  "PARAM04",    NA, "MEDIUM",     "Day 14",    "N",       NA
)

## Derive `BASE` variable from `AVAL`
derive_var_base(
  dataset,
  by_vars = exprs(USUBJID, PARAMCD),
  source_var = AVAL,
  new_var = BASE
)

## Derive `BASEC` variable from `AVALC`
derive_var_base(
  dataset,
  by_vars = exprs(USUBJID, PARAMCD),
  source_var = AVALC,
  new_var = BASEC
)

## Derive `BNRIND` variable from `ANRIND`
derive_var_base(
  dataset,
  by_vars = exprs(USUBJID, PARAMCD),
  source_var = ANRIND,
  new_var = BNRIND
)
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset: 
\code{\link{derive_basetype_records}()},
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_pchg}()},
\code{\link{derive_var_shift}()}
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
