% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admiral_options.R
\name{get_admiral_option}
\alias{get_admiral_option}
\title{Get the Value of an Admiral Option}
\usage{
get_admiral_option(option)
}
\arguments{
\item{option}{A character scalar of commonly used admiral function inputs.

As of now, support only available for
"subject_keys", "signif_digits", and "save_memory".
See \code{set_admiral_options()} for a description of the options.}
}
\value{
The value of the specified option.
}
\description{
Get the Value of an Admiral Option Which Can Be Modified for Advanced Users.
}
\details{
This function allows flexibility for function inputs that may need to be repeated
multiple times in a script, such as \code{subject_keys}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
dm <- tribble(
  ~STUDYID, ~DOMAIN,  ~USUBJID, ~AGE,   ~AGEU,
  "PILOT01",   "DM", "01-1302",   61, "YEARS",
  "PILOT01",   "DM", "17-1344",   64, "YEARS"
)

vs <- tribble(
  ~STUDYID,  ~DOMAIN,  ~USUBJID, ~VSTESTCD,     ~VISIT,     ~VSTPT, ~VSSTRESN,
  "PILOT01",    "VS", "01-1302",   "DIABP", "BASELINE",    "LYING",        76,
  "PILOT01",    "VS", "01-1302",   "DIABP", "BASELINE", "STANDING",        87,
  "PILOT01",    "VS", "01-1302",   "DIABP",   "WEEK 2",    "LYING",        71,
  "PILOT01",    "VS", "01-1302",   "DIABP",   "WEEK 2", "STANDING",        79,
  "PILOT01",    "VS", "17-1344",   "DIABP", "BASELINE",    "LYING",        88,
  "PILOT01",    "VS", "17-1344",   "DIABP", "BASELINE", "STANDING",        86,
  "PILOT01",    "VS", "17-1344",   "DIABP",   "WEEK 2",    "LYING",        84,
  "PILOT01",    "VS", "17-1344",   "DIABP",   "WEEK 2", "STANDING",        82
)

# Merging all dm variables to vs
derive_vars_merged(
  vs,
  dataset_add = select(dm, -DOMAIN),
  by_vars = get_admiral_option("subject_keys")
)
}
\seealso{
\code{\link[=set_admiral_options]{set_admiral_options()}}, \code{\link[=derive_param_exist_flag]{derive_param_exist_flag()}}, \code{\link[=derive_param_tte]{derive_param_tte()}}
\code{\link[=derive_var_dthcaus]{derive_var_dthcaus()}}, \code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_vars_period]{derive_vars_period()}},
\code{\link[=create_period_dataset]{create_period_dataset()}}

Other admiral_options: 
\code{\link{set_admiral_options}()}
}
\concept{admiral_options}
\keyword{admiral_options}
