% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.admix_cluster.R
\name{print.admix_cluster}
\alias{print.admix_cluster}
\title{Results of the clustering algorithm performed over the K populations following admixture models.}
\usage{
\method{print}{admix_cluster}(x, ...)
}
\arguments{
\item{x}{An object of class 'admix_cluster' (see ?admix_clustering).}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Print the detected clusters among the populations under study. This method also prints the number of clusters,
the p-values of statistical tests performed when building the clusters, the estimated weights of the unknown component
distributions inside each cluster, and the discrepancy matrix. The latter represents some kind of distance between the populations.
}
\examples{
\donttest{
## Simulate data (chosen parameters indicate 2 clusters (populations (1,3), (2,4))!):
list.comp <- list(f1 = "gamma", g1 = "exp",
                  f2 = "gamma", g2 = "exp",
                  f3 = "gamma", g3 = "gamma",
                  f4 = "gamma", g4 = "exp")
list.param <- list(f1 = list(shape = 16, rate = 4), g1 = list(rate = 1/3.5),
                   f2 = list(shape = 14, rate = 2), g2 = list(rate = 1/5),
                   f3 = list(shape = 16, rate = 4), g3 = list(shape = 12, rate = 2),
                   f4 = list(shape = 14, rate = 2), g4 = list(rate = 1/7))
A.sim <- rsimmix(n=2600, unknownComp_weight=0.8, comp.dist = list(list.comp$f1,list.comp$g1),
                 comp.param = list(list.param$f1, list.param$g1))$mixt.data
B.sim <- rsimmix(n=3000, unknownComp_weight=0.7, comp.dist = list(list.comp$f2,list.comp$g2),
                 comp.param = list(list.param$f2, list.param$g2))$mixt.data
C.sim <- rsimmix(n=3500, unknownComp_weight=0.6, comp.dist = list(list.comp$f3,list.comp$g3),
                 comp.param = list(list.param$f3, list.param$g3))$mixt.data
D.sim <- rsimmix(n=4800, unknownComp_weight=0.5, comp.dist = list(list.comp$f4,list.comp$g4),
                 comp.param = list(list.param$f4, list.param$g4))$mixt.data
## Look for the clusters:
list.comp <- list(f1 = NULL, g1 = "exp",
                  f2 = NULL, g2 = "exp",
                  f3 = NULL, g3 = "gamma",
                  f4 = NULL, g4 = "exp")
list.param <- list(f1 = NULL, g1 = list(rate = 1/3.5),
                   f2 = NULL, g2 = list(rate = 1/5),
                   f3 = NULL, g3 = list(shape = 12, rate = 2),
                   f4 = NULL, g4 = list(rate = 1/7))
clusters <- admix_clustering(samples = list(A.sim,B.sim,C.sim,D.sim), n_sim_tab = 8,
                             comp.dist=list.comp, comp.param=list.param, conf.level = 0.95,
                             parallel=FALSE, n_cpu=2)
print(clusters)
}

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
