% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVdk_ML_varCov_estimators.R
\name{BVdk_ML_varCov_estimators}
\alias{BVdk_ML_varCov_estimators}
\title{Maximum Likelihood estimation of the variance of the unknown density variance estimator in an admixture model}
\usage{
BVdk_ML_varCov_estimators(data, hat_w, hat_loc, hat_var, comp.dist, comp.param)
}
\arguments{
\item{data}{The observed sample under study.}

\item{hat_w}{Estimate of the unknown component weight.}

\item{hat_loc}{Estimate of the location shift parameter.}

\item{hat_var}{Estimate of the variance of the symmetric density f, obtained by plugging-in the previous estimates. See 'Details'
below for further information.}

\item{comp.dist}{A list with two elements corresponding to component distributions (specified with R native names for these distributions) involved
in the admixture model. Unknown elements must be specified as 'NULL' objects, e.g. when 'f' is unknown: list(f=NULL, g='norm').}

\item{comp.param}{A list with two elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
Unknown elements must be specified as 'NULL' objects, e.g. if 'f' is unknown: list(f=NULL, g=list(mean=0,sd=1)).}
}
\value{
The variance of the estimator of the variance of the unknown component density f.
}
\description{
Parametric estimation of the variance of the variance parameter in Bordes & Vandekerkhove (2010) setting, i.e. considering the
admixture model with probability density function (pdf) l:
l(x) = p*f(x-mu) + (1-p)*g,
where g is the known component of the two-component mixture, p is the mixture proportion, f is the unknown component with
symmetric density, and mu is the location shift parameter. The estimation of the variance of the variance related to the density
f is made by maximum likelihood optimization through the information matrix, with the assumption that the unknown f is gaussian.
}
\details{
Plug-in strategy is defined in Pommeret, D. and Vandekerkhove, P. (2019); Semiparametric density testing in the contamination model;
Electronic Journal of Statistics, 13, pp. 4743--4793. The variance of the estimator variance of the unknown density f
is needed in a testing perspective, since included in the variance of the test statistic. Other details about the information
matrix can be found in Bordes, L. and Vandekerkhove, P. (2010); Semiparametric two-component mixture model when a component is known:
an asymptotically normal estimator; Math. Meth. Stat.; 19, pp. 22--41.
}
\examples{
\donttest{
## Simulate data:
list.comp <- list(f = "norm", g = "norm")
list.param <- list(f = c(mean = 4, sd = 1), g = c(mean = 7, sd = 0.5))
sim.data <- rsimmix(n = 400, unknownComp_weight = 0.9, list.comp, list.param)$mixt.data
## Estimate mixture weight and location shift parameters in real-life:
list.comp <- list(f = NULL, g = "norm")
list.param <- list(f = NULL, g = c(mean = 7, sd = 0.5))
estim <- BVdk_estimParam(data = sim.data, method = "L-BFGS-B",
                         comp.dist = list.comp, comp.param = list.param)
## Estimation of the second-order moment of the known component distribution:
m2_knownComp <- mean(rnorm(n = 1000000, mean = 7, sd = 0.5)^2)
hat_s2 <- (1/estim[1]) * (mean(sim.data^2) - ((1-estim[1])*m2_knownComp)) - estim[2]^2
## Estimated variance of variance estimator related to the unknown symmetric component density:
BVdk_ML_varCov_estimators(data = sim.data, hat_w = estim[1], hat_loc = estim[2],
                          hat_var = hat_s2, comp.dist = list.comp, comp.param = list.param)
}

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
