% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sedrate_gen_helpers.R
\name{sed_rate_from_matrix}
\alias{sed_rate_from_matrix}
\title{make sed rate gen from matrix}
\usage{
sed_rate_from_matrix(height, sedrate, matrix, rate = 1, expand_domain = TRUE)
}
\arguments{
\item{height}{vector of heights}

\item{sedrate}{vector of sed. rates x values}

\item{matrix}{matrix of sed rate y values}

\item{rate}{numeric, rate of the Poisson point process determining frequency of sedimentation rate changes.}

\item{expand_domain}{should sedimentation rates be defined below/above the highest/lowest height in the section? If TRUE, the sed rate values are the values at the closest interpolated point, if FALSE it will be NA}
}
\value{
a function factory for usage with \code{sedrate_to_multiadm}
}
\description{
at height \code{height[i]}, the sedimentation rate is specified by the pdf \verb{approxfun(sedrate, matrix[i,]})
}
\seealso{
\code{\link[=sedrate_to_multiadm]{sedrate_to_multiadm()}} for estimating sedimentation rates based on the outputs, \code{\link[=get_data_from_eTimeOpt]{get_data_from_eTimeOpt()}} for extracting data from the \code{eTimeOpt} function of the astrochron package.
}
