% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agops-impact.R
\name{index_h}
\alias{index_h}
\alias{index.h}
\title{Hirsch's h-index}
\usage{
index_h(x)

index.h(x) # same as index_h(x), deprecated alias
}
\arguments{
\item{x}{a non-negative numeric vector}
}
\value{
a single numeric value
}
\description{
Given a sequence of \eqn{n} non-negative numbers \eqn{x=(x_1,\dots,x_n)},
where \eqn{x_i \ge x_j \ge 0} for \eqn{i \le j},
the \dfn{\eqn{h}-index} (Hirsch, 2005) for \eqn{x} is defined as
\deqn{H(x)=\max\{i=1,\dots,n: x_i \ge i\}}{H(x)=max{i=1,\dots,n: x_i \ge i}}
if \eqn{n \ge 1} and \eqn{x_1 \ge 1}, or \eqn{H(x)=0} otherwise.
}
\details{
If non-increasingly sorted vector is given, the function is O(n).

For historical reasons, this function is also available via its alias,
\code{index.h} [but its usage is deprecated].

See \code{\link{index_rp}} and \code{\link{owmax}} for natural generalizations.

The h-index is the same as the discrete Sugeno integral of \code{x}
w.r.t. the counting measure (see Torra, Narukawa, 2008).
}
\examples{
authors <- list(  # a list of numeric sequences
                  # (e.g. citation counts of the articles
                  # written by some authors)
    "A" =c(23,21,4,2,1,0,0),
    "B" =c(11,5,4,4,3,2,2,2,2,2,1,1,1,0,0,0,0),
    "C" =c(53,43,32,23,14,13,12,8,4,3,2,1,0)
 )
index_h(authors$A)
sapply(authors, index_h)

}
\references{
Hirsch J.E., An index to quantify individual's scientific research output,
\emph{Proceedings of the National Academy of Sciences} 102(46), 2005, pp. 16569-16572.

Mesiar R., Gagolewski M., H-index and other Sugeno integrals:
   Some defects and their compensation,
 IEEE Transactions on Fuzzy Systems 24(6), 2016, pp. 1668-1672.
doi:10.1109/TFUZZ.2016.2516579

Gagolewski M., Mesiar R., Monotone measures and universal integrals
  in a uniform framework for the scientific impact assessment problem,
  Information Sciences 263, 2014, pp. 166-174. doi:10.1016/j.ins.2013.12.004

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7

Sugeno M., \emph{Theory of fuzzy integrals and its applications},
   PhD thesis, Tokyo Institute of Technology, 1974.

Torra V., Narukawa Y., The h-index and the number of citations: Two fuzzy
integrals, \emph{IEEE Transactions on Fuzzy Systems} 16(3), 2008, pp. 795-797.
}
\seealso{
Other impact_functions: \code{\link{index_g}},
  \code{\link{index_lp}}, \code{\link{index_maxprod}},
  \code{\link{index_rp}}, \code{\link{index_w}},
  \code{\link{pord_weakdom}}
}
\concept{impact_functions}
