% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-comonotonicity.R
\name{check_comonotonicity}
\alias{check_comonotonicity}
\title{Check If Two Vectors Are Comonotonic}
\usage{
check_comonotonicity(x, y, incompatible_lengths = NA)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector}

\item{incompatible_lengths}{single logical value,
value to return iff lengths of \code{x} and \code{y} differ}
}
\value{
Returns a single logical value.
}
\description{
This functions determines if two vectors have a common
ordering permutation.
}
\details{
Two vectors \code{x}, \code{y} of equal length \eqn{n} are \emph{comonotonic},
if and only if there exists a permutation \eqn{\sigma} such that
\eqn{x_{\sigma(1)}\le \dots \le x_{\sigma(n)}} and
\eqn{y_{\sigma(1)}\le \dots \le y_{\sigma(n)}}.
Thus, \eqn{\sigma} orders \code{x} and \code{y} simultaneously.
Equivalently, \code{x} and \code{y} are comonotonic,
iff \eqn{(x_i-x_j)(y_i-y_j)\ge 0} for every \code{i,j}.

If there are missing values in \code{x} or \code{y}, the function
returns \code{NA}.

Currently, the implemented algorithm  has \eqn{O(n^2)} time complexity.
}
\references{
Grabisch M., Marichal J.-L., Mesiar R., Pap E., \emph{Aggregation functions},
   Cambridge University Press, 2009.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other binary_relations: \code{\link{pord_nd}},
  \code{\link{pord_spread}}, \code{\link{pord_weakdom}},
  \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}},
  \code{\link{rel_reduction_hasse}}
}
\concept{binary_relations}
