% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agops-classical.R
\name{owa}
\alias{owa}
\alias{wam}
\title{WAM and OWA Operators}
\usage{
owa(x, w = rep(1/length(x), length(x)))

wam(x, w = rep(1/length(x), length(x)))
}
\arguments{
\item{x}{numeric vector to be aggregated}

\item{w}{numeric vector of the same length as \code{x}, with elements in \eqn{[0,1]},
and such that \eqn{\sum_i w_i=1}{sum(x)=1}; weights}
}
\value{
These functions return a single numeric value.
}
\description{
Computes the Weighted Arithmetic Mean or the
Ordered Weighted Averaging aggregation operator.
}
\details{
The OWA operator is given by
\deqn{
\mathsf{OWA}_\mathtt{w}(\mathtt{x})=\sum_{i=1}^{n} w_{i}\,x_{(i)}
}{
OWA_w(x) = sum_i(w_i * x_(i))
}
where \eqn{x_{(i)}}{x_(i)} denotes the \eqn{i}-th smallest
value in \code{x}.

The WAM operator is given by
\deqn{
\mathsf{WAM}_\mathtt{w}(\mathtt{x})=\sum_{i=1}^{n} w_{i}\,x_{i}
}{
WAM_w(x) = sum_i(w_i * x_i)
}

If the elements in \code{w} do not sum up to \eqn{1}, then
they are normalized and a warning is generated.

Both functions by default return the ordinary arithmetic mean.
Special cases of OWA include the trimmed mean (see \code{\link{mean}})
and Winsorized mean.

There is a strong, well-known connection between the OWA operators
and the Choquet integrals.
}
\references{
Choquet G., Theory of capacities, \emph{Annales de l'institut Fourier} 5,
   1954, pp. 131-295.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7

Yager R.R., On ordered weighted averaging aggregation operators
in multicriteria decision making,
\emph{IEEE Transactions on Systems, Man, and Cybernetics} 18(1), 1988, pp. 183-190.
}
\seealso{
Other aggregation_operators: \code{\link{owmax}}
}
\concept{aggregation_operators}
