% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-hasse.R
\name{rel_reduction_hasse}
\alias{rel_reduction_hasse}
\title{Hasse Diagrams}
\usage{
rel_reduction_hasse(R)
}
\arguments{
\item{R}{an object coercible to a 0-1 (logical) square matrix,
representing a binary relation on a finite set.}
}
\value{
The \code{rel_reduction_hasse} function
returns a logical square matrix. \code{\link{dimnames}}
of \code{R} are preserved.
}
\description{
This function computes the reflexive reduction
and a kind of transitive reduction which is useful for drawing Hasse
diagrams.
}
\details{
The input matrix \eqn{R} might not necessarily be acyclic/asymmetric, i.e.,
it may represent any totally preordered set (which induces an equivalence
relation on the underlying preordered set).
The implemented algorithm  runs in \eqn{O(n^3)} time
and first determines the transitive closure of \eqn{R}.
If an irreflexive \eqn{R} is given, then the transitive closures
of \eqn{R} and of the resulting matrix are identical.
Moreover, if \eqn{R} is additionally acyclic, then this function
is equivalent to \code{\link{rel_reduction_transitive}}.
}
\examples{
\dontrun{
# Let ord be a total preorder (a total and transitive binary relation)
# === Plot the Hasse diagram of ord ===
# ===  requires the igraph package  ===
library("igraph")
hasse <- graph.adjacency(rel_reduction_transitive(ord))
plot(hasse, layout=layout.fruchterman.reingold(hasse, dim=2))
}

}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{pord_weakdom}}, \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}}
}
\concept{binary_relations}
