% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_classifier_neuralnet_model.R
\name{TextEmbeddingClassifierNeuralNet}
\alias{TextEmbeddingClassifierNeuralNet}
\title{Text embedding classifier with a neural net}
\value{
Objects of this class are used for assigning texts to classes/categories. For
the creation and training of a classifier an object of class \link{EmbeddedText} and a \code{factor}
are necessary. The object of class \link{EmbeddedText} contains the numerical text
representations (text embeddings) of the raw texts generated by an object of class
\link{TextEmbeddingModel}. The \code{factor} contains the classes/categories for every
text. Missing values (unlabeled cases) are supported. For predictions an object of class
\link{EmbeddedText} has to be used which was created with the same text embedding model as
for training.
}
\description{
Abstract class for neural nets with 'keras' and
'tensorflow'.
}
\concept{Classification}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model}}{('tensorflow_model()')\cr
Field for storing the tensorflow model after loading.}

\item{\code{model_config}}{('list()')\cr
List for storing information about the configuration of the model. This
information is used to predict new data.
\itemize{
\item{\code{model_config$n_req: }}{Number of recurrent layers.}
\item{\code{model_config$n_hidden: }}{Number of dense layers.}
\item{\code{model_config$target_levels: }}{Levels of the target variable. Do not change this manually.}
\item{\code{model_config$input_variables: }}{Order and name of the input variables. Do not change this manually.}
\item{\code{model_config$init_config: }}{List storing all parameters passed to method new().}
}}

\item{\code{last_training}}{('list()')\cr
List for storing the history and the results of the last training. This
information will be overwritten if a new training is started.
\itemize{
\item{\code{last_training$learning_time: }}{Duration of the training process.}
\item{\code{config$history: }}{History of the last training.}
\item{\code{config$data: }}{Object of class table storing the initial frequencies of the passed data.}
\item{\code{config$data_pb:l }}{Matrix storing the number of additional cases (test and training) added
during balanced pseudo-labeling. The rows refer to folds and final training.
The columns refer to the steps during pseudo-labeling.}
\item{\code{config$data_bsc_test: }}{Matrix storing the number of cases for each category used for testing
during the phase of balanced synthetic units. Please note that the
frequencies include original and synthetic cases. In case the number
of original and synthetic cases exceeds the limit for the majority classes,
the frequency represents the number of cases created by cluster analysis.}
\item{\code{config$date: }}{Time when the last training finished.}
\item{\code{config$config: }}{List storing which kind of estimation was requested during the last training.
\itemize{
\item{\code{config$config$use_bsc:  }}{\code{TRUE} if  balanced synthetic cases were requested. \code{FALSE}
if not.}
\item{\code{config$config$use_baseline: }}{\code{TRUE} if baseline estimation were requested. \code{FALSE}
if not.}
\item{\code{ config$config$use_bpl: }}{\code{TRUE} if  balanced, pseudo-labeling cases were requested. \code{FALSE}
if not.}
}}
}}

\item{\code{reliability}}{('list()')\cr
List for storing central reliability measures of the last training.
\itemize{
\item{\code{reliability$test_metric: }}{Array containing the reliability measures for the validation data for
every fold, method, and step (in case of pseudo-labeling).}
\item{\code{reliability$test_metric_mean: }}{Array containing the reliability measures for the validation data for
every method and step (in case of pseudo-labeling). The values represent
the mean values for every fold.}
\item{\code{reliability$raw_iota_objects: }}{List containing all iota_object generated with the package [iotarelr]{iotarelr}
for every fold at the start and the end of the last training.
\itemize{
\item{\code{reliability$raw_iota_objects$iota_objects_start: }}{List of objects with class \code{iotarelr_iota2} containing the
estimated iota reliability of the second generation for the baseline model
for every fold.
If the estimation of the baseline model is not requested, the list is
set to \code{NULL}.}
\item{\code{reliability$raw_iota_objects$iota_objects_end: }}{List of objects with class \code{iotarelr_iota2} containing the
estimated iota reliability of the second generation for the final model
for every fold. Depending of the requested training method these values
refer to the baseline model, a trained model on the basis of balanced
synthetic cases, balanced pseudo labeling or a combination of balanced
synthetic cases with pseudo labeling.}
\item{\code{reliability$raw_iota_objects$iota_objects_start_free: }}{List of objects with class \code{iotarelr_iota2} containing the
estimated iota reliability of the second generation for the baseline model
for every fold.
If the estimation of the baseline model is not requested, the list is
set to \code{NULL}.Please note that the model is estimated without
forcing the Assignment Error Matrix to be in line with the assumption of weak superiority.}
\item{\code{reliability$raw_iota_objects$iota_objects_end_free: }}{List of objects with class \code{iotarelr_iota2} containing the
estimated iota reliability of the second generation for the final model
for every fold. Depending of the requested training method, these values
refer to the baseline model, a trained model on the basis of balanced
synthetic cases, balanced pseudo-labeling or a combination of balanced
synthetic cases and pseudo-labeling.
Please note that the model is estimated without
forcing the Assignment Error Matrix to be in line with the assumption of weak superiority.}
}
}
\item{\code{reliability$iota_object_start: }}{Object of class \code{iotarelr_iota2} as a mean of the individual objects
for every fold. If the estimation of the baseline model is not requested, the list is
set to \code{NULL}.}
\item{\code{ reliability$iota_object_start_free: }}{Object of class \code{iotarelr_iota2} as a mean of the individual objects
for every fold. If the estimation of the baseline model is not requested, the list is
set to \code{NULL}.
Please note that the model is estimated without
forcing the Assignment Error Matrix to be in line with the assumption of weak superiority.}
\item{\code{reliability$iota_object_end: }}{Object of class \code{iotarelr_iota2} as a mean of the individual objects
for every fold.
Depending on the requested training method, this object
refers to the baseline model, a trained model on the basis of balanced
synthetic cases, balanced pseudo-labeling or a combination of balanced
synthetic cases and pseudo-labeling.}
\item{\code{reliability$iota_object_end_free: }}{Object of class \code{iotarelr_iota2} as a mean of the individual objects
for every fold.
Depending on the requested training method, this object
refers to the baseline model, a trained model on the basis of balanced
synthetic cases, balanced pseudo-labeling or a combination of balanced
synthetic cases and pseudo-labeling.
Please note that the model is estimated without
forcing the Assignment Error Matrix to be in line with the assumption of weak superiority.}
}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TextEmbeddingClassifierNeuralNet-new}{\code{TextEmbeddingClassifierNeuralNet$new()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-train}{\code{TextEmbeddingClassifierNeuralNet$train()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-predict}{\code{TextEmbeddingClassifierNeuralNet$predict()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_model_info}{\code{TextEmbeddingClassifierNeuralNet$get_model_info()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_text_embedding_model}{\code{TextEmbeddingClassifierNeuralNet$get_text_embedding_model()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-set_publication_info}{\code{TextEmbeddingClassifierNeuralNet$set_publication_info()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_publication_info}{\code{TextEmbeddingClassifierNeuralNet$get_publication_info()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-set_software_license}{\code{TextEmbeddingClassifierNeuralNet$set_software_license()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_software_license}{\code{TextEmbeddingClassifierNeuralNet$get_software_license()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-set_documentation_license}{\code{TextEmbeddingClassifierNeuralNet$set_documentation_license()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_documentation_license}{\code{TextEmbeddingClassifierNeuralNet$get_documentation_license()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-set_model_description}{\code{TextEmbeddingClassifierNeuralNet$set_model_description()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_model_description}{\code{TextEmbeddingClassifierNeuralNet$get_model_description()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-save_model}{\code{TextEmbeddingClassifierNeuralNet$save_model()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-load_model}{\code{TextEmbeddingClassifierNeuralNet$load_model()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_package_versions}{\code{TextEmbeddingClassifierNeuralNet$get_package_versions()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-get_sustainability_data}{\code{TextEmbeddingClassifierNeuralNet$get_sustainability_data()}}
\item \href{#method-TextEmbeddingClassifierNeuralNet-clone}{\code{TextEmbeddingClassifierNeuralNet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-new"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-new}{}}}
\subsection{Method \code{new()}}{
Creating a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$new(
  name = NULL,
  label = NULL,
  text_embeddings = NULL,
  targets = NULL,
  hidden = c(128),
  rec = c(128),
  self_attention_heads = 0,
  dropout = 0.4,
  recurrent_dropout = 0.4,
  l2_regularizer = 0.01,
  optimizer = "adam",
  act_fct = "gelu",
  rec_act_fct = "tanh"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{Character} Name of the new classifier. Please refer to
common name conventions. Free text can be used with parameter \code{label}.}

\item{\code{label}}{\code{Character} Label for the new classifier. Here you can use
free text.}

\item{\code{text_embeddings}}{An object of class\code{TextEmbeddingModel}.}

\item{\code{targets}}{\code{factor} containing the target values of the classifier.}

\item{\code{hidden}}{\code{vector} containing the number of neurons for each dense layer.
The length of the vector determines the number of dense layers. If you want no dense layer,
set this parameter to \code{NULL}.}

\item{\code{rec}}{\code{vector} containing the number of neurons for each recurrent layer.
The length of the vector determines the number of dense layers. If you want no dense layer,
set this parameter to \code{NULL}.}

\item{\code{self_attention_heads}}{\code{integer} determining the number of attention heads
for a self-attention layer. If this value is greater 0, a self-attention layer is added
between the recurrent and dense layers together with a normalization and a
recurrent layer. If set to 0, none of these layers are added.}

\item{\code{dropout}}{\code{double} ranging between 0 and lower 1, determining the
dropout for each recurrent layer.}

\item{\code{recurrent_dropout}}{\code{double} ranging between 0 and lower 1, determining the
recurrent dropout for each recurrent layer.}

\item{\code{l2_regularizer}}{\code{double} determining the l2 regularizer for every dense layer.}

\item{\code{optimizer}}{Object of class \code{keras.optimizers}.}

\item{\code{act_fct}}{\code{character} naming the activation function for all dense layers.}

\item{\code{rec_act_fct}}{\code{character} naming the activation function for all recurrent layers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an object of class \link{TextEmbeddingClassifierNeuralNet} which is ready for
training.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-train"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-train}{}}}
\subsection{Method \code{train()}}{
Method for training a neural net with keras and
tensorflow.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$train(
  data_embeddings,
  data_targets,
  data_n_test_samples = 5,
  use_baseline = TRUE,
  bsl_val_size = 0.25,
  use_bsc = TRUE,
  bsc_methods = c("dbsmote"),
  bsc_max_k = 10,
  bsc_val_size = 0.25,
  bsc_add_all = FALSE,
  use_bpl = TRUE,
  bpl_max_steps = 3,
  bpl_epochs_per_step = 1,
  bpl_dynamic_inc = FALSE,
  bpl_balance = TRUE,
  bpl_max = 1,
  bpl_anchor = 1,
  bpl_min = 0,
  bpl_weight_inc = 0.02,
  bpl_weight_start = 0,
  bpl_model_reset = FALSE,
  sustain_track = TRUE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  epochs = 40,
  batch_size = 32,
  dir_checkpoint,
  trace = TRUE,
  keras_trace = 2,
  n_cores = 2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_embeddings}}{Object of class \code{TextEmbeddingModel}.}

\item{\code{data_targets}}{\code{Factor} containing the labels for cases
stored in \code{data_embeddings}. Factor must be named and has to use the
same names used in \code{data_embeddings}.}

\item{\code{data_n_test_samples}}{\code{int} determining the number of cross-fold
samples.}

\item{\code{use_baseline}}{\code{bool} \code{TRUE} if the calculation of a baseline
model is requested. This option is only relevant for \code{use_bsc=TRUE} or
\code{use_pbl=TRUE}. If both are \code{FALSE}, a baseline model is calculated.}

\item{\code{bsl_val_size}}{\code{double} between 0 and 1, indicating the proportion of cases of each class
which should be used for the validation sample during the estimation of the baseline model.
The remaining cases are part of the training data.}

\item{\code{use_bsc}}{\code{bool} \code{TRUE} if the estimation should integrate
balanced synthetic cases. \code{FALSE} if not.}

\item{\code{bsc_methods}}{\code{vector} containing the methods for generating
synthetic cases via \link[smotefamily]{smotefamily}. Multiple methods can
be passed. Currently \code{bsc_methods=c("adas")}, \code{bsc_methods=c("smote")}
and \code{bsc_methods=c("dbsmote")} are possible.}

\item{\code{bsc_max_k}}{\code{int} determining the maximal number of k which is used
for creating synthetic units.}

\item{\code{bsc_val_size}}{\code{double} between 0 and 1, indicating the proportion of cases of each class
which should be used for the validation sample during the estimation with synthetic cases.}

\item{\code{bsc_add_all}}{\code{bool} If \code{FALSE} only synthetic cases necessary to fill
the gab between the class and the major class are added to the data. If \code{TRUE} all
generated synthetic cases are added to the data.}

\item{\code{use_bpl}}{\code{bool} \code{TRUE} if the estimation should integrate
balanced pseudo-labeling. \code{FALSE} if not.}

\item{\code{bpl_max_steps}}{\code{int} determining the maximum number of steps during
pseudo-labeling.}

\item{\code{bpl_epochs_per_step}}{\code{int} Number of training epochs within every step.}

\item{\code{bpl_dynamic_inc}}{\code{bool} If \code{TRUE}, only a specific percentage
of cases is included during each step. The percentage is determined by
\eqn{step/bpl_max_steps}. If \code{FALSE}, all cases are used.}

\item{\code{bpl_balance}}{\code{bool} If \code{TRUE}, the same number of cases for
every category/class of the pseudo-labeled data are used with training. That
is, the number of cases is determined by the minor class/category.}

\item{\code{bpl_max}}{\code{double} between 0 and 1, setting the maximal level of
confidence for considering a case for pseudo-labeling.}

\item{\code{bpl_anchor}}{\code{double} between 0 and 1 indicating the reference
point for sorting the new cases of every label. See notes for more details.}

\item{\code{bpl_min}}{\code{double} between 0 and 1, setting the minimal level of
confidence for considering a case for pseudo-labeling.}

\item{\code{bpl_weight_inc}}{\code{double} value how much the sample weights
should be increased for the cases with pseudo-labels in every step.}

\item{\code{bpl_weight_start}}{\code{dobule} Starting value for the weights of the
unlabeled cases.}

\item{\code{bpl_model_reset}}{\code{bool} If \code{TRUE}, model is re-initialized at every
step.}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked
during training via the python library codecarbon.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable
must be set if sustainability should be tracked. A list can be found on
Wikipedia: \url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}.}

\item{\code{sustain_region}}{Region within a country. Only available for USA and
Canada See the documentation of codecarbon for more information.
\url{https://mlco2.github.io/codecarbon/parameters.html}}

\item{\code{sustain_interval}}{\code{integer} Interval in seconds for measuring power
usage.}

\item{\code{epochs}}{\code{int} Number of training epochs.}

\item{\code{batch_size}}{\code{int} Size of batches.}

\item{\code{dir_checkpoint}}{\code{string} Path to the directory where
the checkpoint during training should be saved. If the directory does not
exist, it is created.}

\item{\code{trace}}{\code{bool} \code{TRUE}, if information about the estimation
phase should be printed to the console.}

\item{\code{keras_trace}}{\code{int} \code{keras_trace=0} does not print any
information about the training process from keras on the console.
\code{keras_trace=1} prints a progress bar. \code{keras_trace=2} prints
one line of information for every epoch.}

\item{\code{n_cores}}{\code{int} Number of cores used for creating synthetic units.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\itemize{

\item{bsc_max_k: }{All values from 2 up to bsc_max_k are successively used. If
the number of bsc_max_k is too high, the value is reduced to a number that
allows the calculating of synthetic units.}

\item{bpl_anchor: }{With the help of this value, the new cases are sorted. For
this aim, the distance from the anchor is calculated and all cases are arranged
into an ascending order.
}
}
}

\subsection{Returns}{
Function does not return a value. It changes the object into a trained
classifier.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-predict"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-predict}{}}}
\subsection{Method \code{predict()}}{
Method for predicting new data with a trained neural net.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$predict(newdata, batch_size = 32, verbose = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{Object of class \code{TextEmbeddingModel} or
\code{data.frame} for which predictions should be made.}

\item{\code{batch_size}}{\code{int} Size of batches.}

\item{\code{verbose}}{\code{int} \code{verbose=0} does not cat any
information about the training process from keras on the console.
\code{verbose=1} prints a progress bar. \code{verbose=2} prints
one line of information for every epoch.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a \code{data.frame} containing the predictions and
the probabilities of the different labels for each case.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_model_info"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_model_info}{}}}
\subsection{Method \code{get_model_info()}}{
Method for requesting the model information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_model_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} of all relevant model information
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_text_embedding_model"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_text_embedding_model}{}}}
\subsection{Method \code{get_text_embedding_model()}}{
Method for requesting the text embedding model information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_text_embedding_model()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} of all relevant model information on the text embedding model
underlying the classifier
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-set_publication_info"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-set_publication_info}{}}}
\subsection{Method \code{set_publication_info()}}{
Method for setting publication information of the classifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$set_publication_info(
  authors,
  citation,
  url = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{authors}}{List of authors.}

\item{\code{citation}}{Free text citation.}

\item{\code{url}}{URL of a corresponding homepage.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used for setting the private
members for publication information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_publication_info"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_publication_info}{}}}
\subsection{Method \code{get_publication_info()}}{
Method for requesting the bibliographic information of the classifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_publication_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} with all saved bibliographic information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-set_software_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-set_software_license}{}}}
\subsection{Method \code{set_software_license()}}{
Method for setting the license of the classifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$set_software_license(license = "GPL-3")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{license}}{\code{string} containing the abbreviation of the license or
the license text.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used for setting the private member for
the software license of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_software_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_software_license}{}}}
\subsection{Method \code{get_software_license()}}{
Method for getting the license of the classifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_software_license()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{license}}{\code{string} containing the abbreviation of the license or
the license text.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{string} representing the license for the software.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-set_documentation_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-set_documentation_license}{}}}
\subsection{Method \code{set_documentation_license()}}{
Method for setting the license of the classifier's documentation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$set_documentation_license(
  license = "CC BY-SA"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{license}}{\code{string} containing the abbreviation of the license or
the license text.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used for setting the private member for
the documentation license of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_documentation_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_documentation_license}{}}}
\subsection{Method \code{get_documentation_license()}}{
Method for getting the license of the classifier's documentation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_documentation_license()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{license}}{\code{string} containing the abbreviation of the license or
the license text.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-set_model_description"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-set_model_description}{}}}
\subsection{Method \code{set_model_description()}}{
Method for setting a description of the classifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$set_model_description(
  eng = NULL,
  native = NULL,
  abstract_eng = NULL,
  abstract_native = NULL,
  keywords_eng = NULL,
  keywords_native = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{eng}}{\code{string} A text describing the training of the learner,
its theoretical and empirical background, and the different output labels
in English.}

\item{\code{native}}{\code{string} A text describing the training of the learner,
its theoretical and empirical background, and the different output labels
in the native language of the classifier.}

\item{\code{abstract_eng}}{\code{string} A text providing a summary of the description
in English.}

\item{\code{abstract_native}}{\code{string} A text providing a summary of the description
in the native language of the classifier.}

\item{\code{keywords_eng}}{\code{vector} of keyword in English.}

\item{\code{keywords_native}}{\code{vector} of keyword in the native language of the classifier.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used for setting the private members for the
description of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_model_description"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_model_description}{}}}
\subsection{Method \code{get_model_description()}}{
Method for requesting the model description.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_model_description()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} with the description of the classifier in English
and the native language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-save_model"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-save_model}{}}}
\subsection{Method \code{save_model()}}{
Method for saving a model to 'tensorflow' SavedModel format
or h5 format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$save_model(dir_path, save_format = "tf")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_path}}{\code{string()} Path of the directory where the model should be
saved.}

\item{\code{save_format}}{Format for saving the model. \code{"tf"} for SavedModel
or \code{"h5"} for HDF5.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It saves the model to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-load_model"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-load_model}{}}}
\subsection{Method \code{load_model()}}{
Method for importing a model from 'tensorflow' SavedModel format
or h5 format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$load_model(dir_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_path}}{\code{string()} Path of the directory where the model is
saved.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used to load the weights
of a model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_package_versions"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_package_versions}{}}}
\subsection{Method \code{get_package_versions()}}{
Method for requesting a summary of the R and python packages'
versions used for creating the classifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_package_versions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a \code{list} containing the versions of the relevant
R and python packages.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-get_sustainability_data"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-get_sustainability_data}{}}}
\subsection{Method \code{get_sustainability_data()}}{
Method for requesting a summary of tracked energy consumption
during training and an estimate of the resulting CO2 equivalents in kg.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$get_sustainability_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a \code{list} containing the tracked energy consumption,
CO2 equivalents in kg, information on the tracker used, and technical
information on the training infrastructure.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingClassifierNeuralNet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingClassifierNeuralNet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingClassifierNeuralNet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
