% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AxialShapeGraph.R
\docType{methods}
\name{connections,AxialShapeGraph-method}
\alias{connections,AxialShapeGraph-method}
\title{Get the Axial ShapeGraph connections}
\usage{
\S4method{connections}{AxialShapeGraph}(map)
}
\arguments{
\item{map}{An Axial ShapeGraph}
}
\value{
A matrix with the connected refs
}
\description{
Get the Axial ShapeGraph connections
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
connections(shapeGraph)
}
