// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include "alcyon_types.h"
#include <Rcpp.h>

using namespace Rcpp;

#ifdef RCPP_USE_GLOBAL_ROSTREAM
Rcpp::Rostream<true>&  Rcpp::Rcout = Rcpp::Rcpp_cout_get();
Rcpp::Rostream<false>& Rcpp::Rcerr = Rcpp::Rcpp_cerr_get();
#endif

// createFromGrid
Rcpp::XPtr<PointMap> createFromGrid(double minX, double minY, double maxX, double maxY, double gridSize);
RcppExport SEXP _alcyon_createFromGrid(SEXP minXSEXP, SEXP minYSEXP, SEXP maxXSEXP, SEXP maxYSEXP, SEXP gridSizeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< double >::type minX(minXSEXP);
    Rcpp::traits::input_parameter< double >::type minY(minYSEXP);
    Rcpp::traits::input_parameter< double >::type maxX(maxXSEXP);
    Rcpp::traits::input_parameter< double >::type maxY(maxYSEXP);
    Rcpp::traits::input_parameter< double >::type gridSize(gridSizeSEXP);
    rcpp_result_gen = Rcpp::wrap(createFromGrid(minX, minY, maxX, maxY, gridSize));
    return rcpp_result_gen;
END_RCPP
}
// blockLines
Rcpp::List blockLines(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::XPtr<ShapeMap> boundaryMapPtr, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_blockLines(SEXP pointMapPtrSEXP, SEXP boundaryMapPtrSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type boundaryMapPtr(boundaryMapPtrSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(blockLines(pointMapPtr, boundaryMapPtr, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// fill
Rcpp::List fill(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::NumericMatrix pointCoords, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_fill(SEXP pointMapPtrSEXP, SEXP pointCoordsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type pointCoords(pointCoordsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(fill(pointMapPtr, pointCoords, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// makeGraph
Rcpp::List makeGraph(Rcpp::XPtr<PointMap> pointMapPtr, bool boundaryGraph, double maxVisibility, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_makeGraph(SEXP pointMapPtrSEXP, SEXP boundaryGraphSEXP, SEXP maxVisibilitySEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< bool >::type boundaryGraph(boundaryGraphSEXP);
    Rcpp::traits::input_parameter< double >::type maxVisibility(maxVisibilitySEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(makeGraph(pointMapPtr, boundaryGraph, maxVisibility, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// unmakeGraph
Rcpp::List unmakeGraph(Rcpp::XPtr<PointMap> pointMapPtr, bool removeLinksWhenUnmaking, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_unmakeGraph(SEXP pointMapPtrSEXP, SEXP removeLinksWhenUnmakingSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< bool >::type removeLinksWhenUnmaking(removeLinksWhenUnmakingSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(unmakeGraph(pointMapPtr, removeLinksWhenUnmaking, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// pointMapGetName
std::string pointMapGetName(Rcpp::XPtr<PointMap> pointMapPtr);
RcppExport SEXP _alcyon_pointMapGetName(SEXP pointMapPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(pointMapGetName(pointMapPtr));
    return rcpp_result_gen;
END_RCPP
}
// pointMapGetLinks
Rcpp::IntegerMatrix pointMapGetLinks(Rcpp::XPtr<PointMap> pointMapPtr);
RcppExport SEXP _alcyon_pointMapGetLinks(SEXP pointMapPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(pointMapGetLinks(pointMapPtr));
    return rcpp_result_gen;
END_RCPP
}
// pointMapGetConnections
Rcpp::IntegerMatrix pointMapGetConnections(Rcpp::XPtr<PointMap> pointMapPtr);
RcppExport SEXP _alcyon_pointMapGetConnections(SEXP pointMapPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(pointMapGetConnections(pointMapPtr));
    return rcpp_result_gen;
END_RCPP
}
// getGridCoordinates
Rcpp::NumericMatrix getGridCoordinates(Rcpp::XPtr<PointMap> pointMapPtr);
RcppExport SEXP _alcyon_getGridCoordinates(SEXP pointMapPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(getGridCoordinates(pointMapPtr));
    return rcpp_result_gen;
END_RCPP
}
// getPointMapAttributeNames
std::vector<std::string> getPointMapAttributeNames(Rcpp::XPtr<PointMap> pointMap);
RcppExport SEXP _alcyon_getPointMapAttributeNames(SEXP pointMapSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMap(pointMapSEXP);
    rcpp_result_gen = Rcpp::wrap(getPointMapAttributeNames(pointMap));
    return rcpp_result_gen;
END_RCPP
}
// getPointMapAttributeData
std::map<std::string, std::vector<double>> getPointMapAttributeData(Rcpp::XPtr<PointMap> pointMap, std::vector<std::string> attributeNames);
RcppExport SEXP _alcyon_getPointMapAttributeData(SEXP pointMapSEXP, SEXP attributeNamesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMap(pointMapSEXP);
    Rcpp::traits::input_parameter< std::vector<std::string> >::type attributeNames(attributeNamesSEXP);
    rcpp_result_gen = Rcpp::wrap(getPointMapAttributeData(pointMap, attributeNames));
    return rcpp_result_gen;
END_RCPP
}
// getPointMapPropertyData
std::map<std::string, std::vector<double>> getPointMapPropertyData(Rcpp::XPtr<PointMap> pointMap, std::vector<std::string> propertyNames);
RcppExport SEXP _alcyon_getPointMapPropertyData(SEXP pointMapSEXP, SEXP propertyNamesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMap(pointMapSEXP);
    Rcpp::traits::input_parameter< std::vector<std::string> >::type propertyNames(propertyNamesSEXP);
    rcpp_result_gen = Rcpp::wrap(getPointMapPropertyData(pointMap, propertyNames));
    return rcpp_result_gen;
END_RCPP
}
// getFilledPoints
Rcpp::NumericMatrix getFilledPoints(Rcpp::XPtr<PointMap> pointMapPtr);
RcppExport SEXP _alcyon_getFilledPoints(SEXP pointMapPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(getFilledPoints(pointMapPtr));
    return rcpp_result_gen;
END_RCPP
}
// getAxialConnections
std::map<std::string, std::vector<int>> getAxialConnections(Rcpp::XPtr<ShapeMap> shapeGraphPtr);
RcppExport SEXP _alcyon_getAxialConnections(SEXP shapeGraphPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(getAxialConnections(shapeGraphPtr));
    return rcpp_result_gen;
END_RCPP
}
// getSegmentConnections
std::map<std::string, std::vector<int>> getSegmentConnections(Rcpp::XPtr<ShapeMap> shapeGraphPtr);
RcppExport SEXP _alcyon_getSegmentConnections(SEXP shapeGraphPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(getSegmentConnections(shapeGraphPtr));
    return rcpp_result_gen;
END_RCPP
}
// getLinksUnlinks
Rcpp::NumericMatrix getLinksUnlinks(Rcpp::XPtr<ShapeGraph> shapeGraphPtr);
RcppExport SEXP _alcyon_getLinksUnlinks(SEXP shapeGraphPtrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    rcpp_result_gen = Rcpp::wrap(getLinksUnlinks(shapeGraphPtr));
    return rcpp_result_gen;
END_RCPP
}
// make
Rcpp::XPtr<ShapeMap> make(std::string name);
RcppExport SEXP _alcyon_make(SEXP nameSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::string >::type name(nameSEXP);
    rcpp_result_gen = Rcpp::wrap(make(name));
    return rcpp_result_gen;
END_RCPP
}
// getName
std::string getName(Rcpp::XPtr<ShapeMap> shapeMap);
RcppExport SEXP _alcyon_getName(SEXP shapeMapSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    rcpp_result_gen = Rcpp::wrap(getName(shapeMap));
    return rcpp_result_gen;
END_RCPP
}
// getShapeMapAttributeNames
std::vector<std::string> getShapeMapAttributeNames(Rcpp::XPtr<ShapeMap> shapeMap);
RcppExport SEXP _alcyon_getShapeMapAttributeNames(SEXP shapeMapSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    rcpp_result_gen = Rcpp::wrap(getShapeMapAttributeNames(shapeMap));
    return rcpp_result_gen;
END_RCPP
}
// getShapeMapAttributeData
std::map<std::string, std::vector<double>> getShapeMapAttributeData(Rcpp::XPtr<ShapeMap> shapeMap, std::vector<std::string> attributeNames);
RcppExport SEXP _alcyon_getShapeMapAttributeData(SEXP shapeMapSEXP, SEXP attributeNamesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    Rcpp::traits::input_parameter< std::vector<std::string> >::type attributeNames(attributeNamesSEXP);
    rcpp_result_gen = Rcpp::wrap(getShapeMapAttributeData(shapeMap, attributeNames));
    return rcpp_result_gen;
END_RCPP
}
// getShapesAsLineCoords
Rcpp::NumericMatrix getShapesAsLineCoords(Rcpp::XPtr<ShapeMap> shapeMap);
RcppExport SEXP _alcyon_getShapesAsLineCoords(SEXP shapeMapSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    rcpp_result_gen = Rcpp::wrap(getShapesAsLineCoords(shapeMap));
    return rcpp_result_gen;
END_RCPP
}
// getShapesAsPolygonCoords
Rcpp::GenericVector getShapesAsPolygonCoords(Rcpp::XPtr<ShapeMap> shapeMap);
RcppExport SEXP _alcyon_getShapesAsPolygonCoords(SEXP shapeMapSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    rcpp_result_gen = Rcpp::wrap(getShapesAsPolygonCoords(shapeMap));
    return rcpp_result_gen;
END_RCPP
}
// getShapesAsPolylineCoords
Rcpp::GenericVector getShapesAsPolylineCoords(Rcpp::XPtr<ShapeMap> shapeMap);
RcppExport SEXP _alcyon_getShapesAsPolylineCoords(SEXP shapeMapSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    rcpp_result_gen = Rcpp::wrap(getShapesAsPolylineCoords(shapeMap));
    return rcpp_result_gen;
END_RCPP
}
// getShapeCoords
Rcpp::List getShapeCoords(Rcpp::XPtr<ShapeMap> shapeMapPtr, int ref);
RcppExport SEXP _alcyon_getShapeCoords(SEXP shapeMapPtrSEXP, SEXP refSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMapPtr(shapeMapPtrSEXP);
    Rcpp::traits::input_parameter< int >::type ref(refSEXP);
    rcpp_result_gen = Rcpp::wrap(getShapeCoords(shapeMapPtr, ref));
    return rcpp_result_gen;
END_RCPP
}
// getShapeAttributes
Rcpp::List getShapeAttributes(Rcpp::XPtr<ShapeMap> shapeMapPtr, int ref);
RcppExport SEXP _alcyon_getShapeAttributes(SEXP shapeMapPtrSEXP, SEXP refSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMapPtr(shapeMapPtrSEXP);
    Rcpp::traits::input_parameter< int >::type ref(refSEXP);
    rcpp_result_gen = Rcpp::wrap(getShapeAttributes(shapeMapPtr, ref));
    return rcpp_result_gen;
END_RCPP
}
// agentAnalysis
Rcpp::List agentAnalysis(Rcpp::XPtr<PointMap> pointMapPtr, int systemTimesteps, float releaseRate, int agentLifeTimesteps, int agentFov, int agentStepsToDecision, int agentLookMode, Rcpp::NumericMatrix agentReleaseLocations, int randomReleaseLocationSeed, int recordTrailForAgents, bool getGateCounts, const Rcpp::Nullable<bool> copyMapNV, const Rcpp::Nullable<bool> verboseNV, const Rcpp::Nullable<bool> progressNV);
RcppExport SEXP _alcyon_agentAnalysis(SEXP pointMapPtrSEXP, SEXP systemTimestepsSEXP, SEXP releaseRateSEXP, SEXP agentLifeTimestepsSEXP, SEXP agentFovSEXP, SEXP agentStepsToDecisionSEXP, SEXP agentLookModeSEXP, SEXP agentReleaseLocationsSEXP, SEXP randomReleaseLocationSeedSEXP, SEXP recordTrailForAgentsSEXP, SEXP getGateCountsSEXP, SEXP copyMapNVSEXP, SEXP verboseNVSEXP, SEXP progressNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< int >::type systemTimesteps(systemTimestepsSEXP);
    Rcpp::traits::input_parameter< float >::type releaseRate(releaseRateSEXP);
    Rcpp::traits::input_parameter< int >::type agentLifeTimesteps(agentLifeTimestepsSEXP);
    Rcpp::traits::input_parameter< int >::type agentFov(agentFovSEXP);
    Rcpp::traits::input_parameter< int >::type agentStepsToDecision(agentStepsToDecisionSEXP);
    Rcpp::traits::input_parameter< int >::type agentLookMode(agentLookModeSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type agentReleaseLocations(agentReleaseLocationsSEXP);
    Rcpp::traits::input_parameter< int >::type randomReleaseLocationSeed(randomReleaseLocationSeedSEXP);
    Rcpp::traits::input_parameter< int >::type recordTrailForAgents(recordTrailForAgentsSEXP);
    Rcpp::traits::input_parameter< bool >::type getGateCounts(getGateCountsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type verboseNV(verboseNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type progressNV(progressNVSEXP);
    rcpp_result_gen = Rcpp::wrap(agentAnalysis(pointMapPtr, systemTimesteps, releaseRate, agentLifeTimesteps, agentFov, agentStepsToDecision, agentLookMode, agentReleaseLocations, randomReleaseLocationSeed, recordTrailForAgents, getGateCounts, copyMapNV, verboseNV, progressNV));
    return rcpp_result_gen;
END_RCPP
}
// makeAllLineMap
Rcpp::XPtr<AllLineMap> makeAllLineMap(Rcpp::XPtr<ShapeMap> boundsMap, double seedX, double seedY);
RcppExport SEXP _alcyon_makeAllLineMap(SEXP boundsMapSEXP, SEXP seedXSEXP, SEXP seedYSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type boundsMap(boundsMapSEXP);
    Rcpp::traits::input_parameter< double >::type seedX(seedXSEXP);
    Rcpp::traits::input_parameter< double >::type seedY(seedYSEXP);
    rcpp_result_gen = Rcpp::wrap(makeAllLineMap(boundsMap, seedX, seedY));
    return rcpp_result_gen;
END_RCPP
}
// extractFewestLineMaps
Rcpp::List extractFewestLineMaps(Rcpp::XPtr<AllLineMap> allLineMap);
RcppExport SEXP _alcyon_extractFewestLineMaps(SEXP allLineMapSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<AllLineMap> >::type allLineMap(allLineMapSEXP);
    rcpp_result_gen = Rcpp::wrap(extractFewestLineMaps(allLineMap));
    return rcpp_result_gen;
END_RCPP
}
// runAxialAnalysis
Rcpp::List runAxialAnalysis(Rcpp::XPtr<ShapeGraph> shapeGraph, const Rcpp::NumericVector radii, const Rcpp::Nullable<std::string> weightedMeasureColNameNV, const Rcpp::Nullable<bool> includeChoiceNV, const Rcpp::Nullable<bool> includeIntermediateMetricsNV, const Rcpp::Nullable<bool> copyMapNV, const Rcpp::Nullable<bool> verboseNV, const Rcpp::Nullable<bool> progressNV);
RcppExport SEXP _alcyon_runAxialAnalysis(SEXP shapeGraphSEXP, SEXP radiiSEXP, SEXP weightedMeasureColNameNVSEXP, SEXP includeChoiceNVSEXP, SEXP includeIntermediateMetricsNVSEXP, SEXP copyMapNVSEXP, SEXP verboseNVSEXP, SEXP progressNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraph(shapeGraphSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector >::type radii(radiiSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<std::string> >::type weightedMeasureColNameNV(weightedMeasureColNameNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type includeChoiceNV(includeChoiceNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type includeIntermediateMetricsNV(includeIntermediateMetricsNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type verboseNV(verboseNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type progressNV(progressNVSEXP);
    rcpp_result_gen = Rcpp::wrap(runAxialAnalysis(shapeGraph, radii, weightedMeasureColNameNV, includeChoiceNV, includeIntermediateMetricsNV, copyMapNV, verboseNV, progressNV));
    return rcpp_result_gen;
END_RCPP
}
// runAxialLocalAnalysis
Rcpp::List runAxialLocalAnalysis(Rcpp::XPtr<ShapeGraph> shapeGraph, const Rcpp::Nullable<bool> copyMapNV, const Rcpp::Nullable<bool> verboseNV, const Rcpp::Nullable<bool> progressNV);
RcppExport SEXP _alcyon_runAxialLocalAnalysis(SEXP shapeGraphSEXP, SEXP copyMapNVSEXP, SEXP verboseNVSEXP, SEXP progressNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraph(shapeGraphSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type verboseNV(verboseNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type progressNV(progressNVSEXP);
    rcpp_result_gen = Rcpp::wrap(runAxialLocalAnalysis(shapeGraph, copyMapNV, verboseNV, progressNV));
    return rcpp_result_gen;
END_RCPP
}
// axialStepDepth
Rcpp::List axialStepDepth(Rcpp::XPtr<ShapeGraph> shapeGraph, const int stepType, const std::vector<double> stepDepthPointsX, const std::vector<double> stepDepthPointsY, const Rcpp::Nullable<bool> copyMapNV, const Rcpp::Nullable<bool> verboseNV, const Rcpp::Nullable<bool> progressNV);
RcppExport SEXP _alcyon_axialStepDepth(SEXP shapeGraphSEXP, SEXP stepTypeSEXP, SEXP stepDepthPointsXSEXP, SEXP stepDepthPointsYSEXP, SEXP copyMapNVSEXP, SEXP verboseNVSEXP, SEXP progressNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraph(shapeGraphSEXP);
    Rcpp::traits::input_parameter< const int >::type stepType(stepTypeSEXP);
    Rcpp::traits::input_parameter< const std::vector<double> >::type stepDepthPointsX(stepDepthPointsXSEXP);
    Rcpp::traits::input_parameter< const std::vector<double> >::type stepDepthPointsY(stepDepthPointsYSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type verboseNV(verboseNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type progressNV(progressNVSEXP);
    rcpp_result_gen = Rcpp::wrap(axialStepDepth(shapeGraph, stepType, stepDepthPointsX, stepDepthPointsY, copyMapNV, verboseNV, progressNV));
    return rcpp_result_gen;
END_RCPP
}
// getSfShapeMapExpectedColName
std::string getSfShapeMapExpectedColName(Rcpp::DataFrame& df, int rColIdx);
RcppExport SEXP _alcyon_getSfShapeMapExpectedColName(SEXP dfSEXP, SEXP rColIdxSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::DataFrame& >::type df(dfSEXP);
    Rcpp::traits::input_parameter< int >::type rColIdx(rColIdxSEXP);
    rcpp_result_gen = Rcpp::wrap(getSfShapeMapExpectedColName(df, rColIdx));
    return rcpp_result_gen;
END_RCPP
}
// getAxialToSegmentExpectedColName
std::string getAxialToSegmentExpectedColName(std::string& colName);
RcppExport SEXP _alcyon_getAxialToSegmentExpectedColName(SEXP colNameSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::string& >::type colName(colNameSEXP);
    rcpp_result_gen = Rcpp::wrap(getAxialToSegmentExpectedColName(colName));
    return rcpp_result_gen;
END_RCPP
}
// toShapeMap
Rcpp::XPtr<ShapeMap> toShapeMap(Rcpp::DataFrame& df, Rcpp::Nullable<std::vector<int>> keepColumnIdxsNV);
RcppExport SEXP _alcyon_toShapeMap(SEXP dfSEXP, SEXP keepColumnIdxsNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::DataFrame& >::type df(dfSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<std::vector<int>> >::type keepColumnIdxsNV(keepColumnIdxsNVSEXP);
    rcpp_result_gen = Rcpp::wrap(toShapeMap(df, keepColumnIdxsNV));
    return rcpp_result_gen;
END_RCPP
}
// toAxialShapeGraph
Rcpp::List toAxialShapeGraph(Rcpp::XPtr<ShapeMap> shapeMap, Rcpp::Nullable<std::string> nameNV, Rcpp::Nullable<bool> copydataNV);
RcppExport SEXP _alcyon_toAxialShapeGraph(SEXP shapeMapSEXP, SEXP nameNVSEXP, SEXP copydataNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<std::string> >::type nameNV(nameNVSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<bool> >::type copydataNV(copydataNVSEXP);
    rcpp_result_gen = Rcpp::wrap(toAxialShapeGraph(shapeMap, nameNV, copydataNV));
    return rcpp_result_gen;
END_RCPP
}
// axialToSegment
Rcpp::XPtr<ShapeGraph> axialToSegment(Rcpp::XPtr<ShapeGraph> shapeGraph, Rcpp::Nullable<std::string> nameNV, Rcpp::Nullable<bool> copydataNV, Rcpp::Nullable<double> stubremovalNV);
RcppExport SEXP _alcyon_axialToSegment(SEXP shapeGraphSEXP, SEXP nameNVSEXP, SEXP copydataNVSEXP, SEXP stubremovalNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraph(shapeGraphSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<std::string> >::type nameNV(nameNVSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<bool> >::type copydataNV(copydataNVSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<double> >::type stubremovalNV(stubremovalNVSEXP);
    rcpp_result_gen = Rcpp::wrap(axialToSegment(shapeGraph, nameNV, copydataNV, stubremovalNV));
    return rcpp_result_gen;
END_RCPP
}
// shapeMapToSegment
Rcpp::List shapeMapToSegment(Rcpp::XPtr<ShapeMap> shapeMap, Rcpp::Nullable<std::string> nameNV, Rcpp::Nullable<bool> keeporiginalNV, Rcpp::Nullable<bool> copydataNV, Rcpp::Nullable<double> stubremovalNV);
RcppExport SEXP _alcyon_shapeMapToSegment(SEXP shapeMapSEXP, SEXP nameNVSEXP, SEXP keeporiginalNVSEXP, SEXP copydataNVSEXP, SEXP stubremovalNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMap(shapeMapSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<std::string> >::type nameNV(nameNVSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<bool> >::type keeporiginalNV(keeporiginalNVSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<bool> >::type copydataNV(copydataNVSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<double> >::type stubremovalNV(stubremovalNVSEXP);
    rcpp_result_gen = Rcpp::wrap(shapeMapToSegment(shapeMap, nameNV, keeporiginalNV, copydataNV, stubremovalNV));
    return rcpp_result_gen;
END_RCPP
}
// makeIsovists
Rcpp::XPtr<ShapeMap> makeIsovists(Rcpp::XPtr<ShapeMap> boundsMap, Rcpp::NumericMatrix pointCoords, Rcpp::NumericVector directionAngles, Rcpp::NumericVector fieldOfViewAngles, bool simple_version);
RcppExport SEXP _alcyon_makeIsovists(SEXP boundsMapSEXP, SEXP pointCoordsSEXP, SEXP directionAnglesSEXP, SEXP fieldOfViewAnglesSEXP, SEXP simple_versionSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type boundsMap(boundsMapSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type pointCoords(pointCoordsSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type directionAngles(directionAnglesSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type fieldOfViewAngles(fieldOfViewAnglesSEXP);
    Rcpp::traits::input_parameter< bool >::type simple_version(simple_versionSEXP);
    rcpp_result_gen = Rcpp::wrap(makeIsovists(boundsMap, pointCoords, directionAngles, fieldOfViewAngles, simple_version));
    return rcpp_result_gen;
END_RCPP
}
// shapeGraphLinkCoords
Rcpp::List shapeGraphLinkCoords(Rcpp::XPtr<ShapeGraph> shapeGraphPtr, Rcpp::NumericMatrix coords, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_shapeGraphLinkCoords(SEXP shapeGraphPtrSEXP, SEXP coordsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type coords(coordsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(shapeGraphLinkCoords(shapeGraphPtr, coords, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// shapeGraphLinkRefs
Rcpp::List shapeGraphLinkRefs(Rcpp::XPtr<ShapeGraph> shapeGraphPtr, Rcpp::IntegerMatrix refs, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_shapeGraphLinkRefs(SEXP shapeGraphPtrSEXP, SEXP refsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerMatrix >::type refs(refsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(shapeGraphLinkRefs(shapeGraphPtr, refs, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// pointMapLinkCoords
Rcpp::List pointMapLinkCoords(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::NumericMatrix coords, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_pointMapLinkCoords(SEXP pointMapPtrSEXP, SEXP coordsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type coords(coordsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(pointMapLinkCoords(pointMapPtr, coords, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// pointMapLinkRefs
Rcpp::List pointMapLinkRefs(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::IntegerMatrix refs, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_pointMapLinkRefs(SEXP pointMapPtrSEXP, SEXP refsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerMatrix >::type refs(refsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(pointMapLinkRefs(pointMapPtr, refs, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// shapeMapUnlinkCoords
Rcpp::List shapeMapUnlinkCoords(Rcpp::XPtr<ShapeGraph> shapeGraphPtr, Rcpp::NumericMatrix coords, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_shapeMapUnlinkCoords(SEXP shapeGraphPtrSEXP, SEXP coordsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type coords(coordsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(shapeMapUnlinkCoords(shapeGraphPtr, coords, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// shapeGraphUnlinkAtCrossPoint
Rcpp::List shapeGraphUnlinkAtCrossPoint(Rcpp::XPtr<ShapeGraph> shapeGraphPtr, Rcpp::NumericMatrix coords, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_shapeGraphUnlinkAtCrossPoint(SEXP shapeGraphPtrSEXP, SEXP coordsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type coords(coordsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(shapeGraphUnlinkAtCrossPoint(shapeGraphPtr, coords, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// shapeMapUnlinkRefs
Rcpp::List shapeMapUnlinkRefs(Rcpp::XPtr<ShapeGraph> shapeGraphPtr, Rcpp::IntegerMatrix refs, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_shapeMapUnlinkRefs(SEXP shapeGraphPtrSEXP, SEXP refsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraphPtr(shapeGraphPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerMatrix >::type refs(refsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(shapeMapUnlinkRefs(shapeGraphPtr, refs, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// pointMapUnlinkCoords
Rcpp::List pointMapUnlinkCoords(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::NumericMatrix coords, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_pointMapUnlinkCoords(SEXP pointMapPtrSEXP, SEXP coordsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type coords(coordsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(pointMapUnlinkCoords(pointMapPtr, coords, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// pointMapUnlinkRefs
Rcpp::List pointMapUnlinkRefs(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::IntegerMatrix refs, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_pointMapUnlinkRefs(SEXP pointMapPtrSEXP, SEXP refsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerMatrix >::type refs(refsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(pointMapUnlinkRefs(pointMapPtr, refs, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// readMetaGraph
Rcpp::List readMetaGraph(std::string fileName, Rcpp::Nullable<bool> verboseNV);
RcppExport SEXP _alcyon_readMetaGraph(SEXP fileNameSEXP, SEXP verboseNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::string >::type fileName(fileNameSEXP);
    Rcpp::traits::input_parameter< Rcpp::Nullable<bool> >::type verboseNV(verboseNVSEXP);
    rcpp_result_gen = Rcpp::wrap(readMetaGraph(fileName, verboseNV));
    return rcpp_result_gen;
END_RCPP
}
// runSegmentAnalysis
Rcpp::List runSegmentAnalysis(Rcpp::XPtr<ShapeGraph> shapeGraph, const Rcpp::NumericVector radii, const int radiusStepType, const int analysisStepType, const Rcpp::Nullable<std::string> weightedMeasureColNameNV, const Rcpp::Nullable<bool> includeChoiceNV, const Rcpp::Nullable<int> tulipBinsNV, const Rcpp::Nullable<bool> selOnlyNV, const Rcpp::Nullable<bool> copyMapNV, const Rcpp::Nullable<bool> verboseNV, const Rcpp::Nullable<bool> progressNV);
RcppExport SEXP _alcyon_runSegmentAnalysis(SEXP shapeGraphSEXP, SEXP radiiSEXP, SEXP radiusStepTypeSEXP, SEXP analysisStepTypeSEXP, SEXP weightedMeasureColNameNVSEXP, SEXP includeChoiceNVSEXP, SEXP tulipBinsNVSEXP, SEXP selOnlyNVSEXP, SEXP copyMapNVSEXP, SEXP verboseNVSEXP, SEXP progressNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraph(shapeGraphSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector >::type radii(radiiSEXP);
    Rcpp::traits::input_parameter< const int >::type radiusStepType(radiusStepTypeSEXP);
    Rcpp::traits::input_parameter< const int >::type analysisStepType(analysisStepTypeSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<std::string> >::type weightedMeasureColNameNV(weightedMeasureColNameNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type includeChoiceNV(includeChoiceNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<int> >::type tulipBinsNV(tulipBinsNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type selOnlyNV(selOnlyNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type verboseNV(verboseNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type progressNV(progressNVSEXP);
    rcpp_result_gen = Rcpp::wrap(runSegmentAnalysis(shapeGraph, radii, radiusStepType, analysisStepType, weightedMeasureColNameNV, includeChoiceNV, tulipBinsNV, selOnlyNV, copyMapNV, verboseNV, progressNV));
    return rcpp_result_gen;
END_RCPP
}
// segmentStepDepth
Rcpp::List segmentStepDepth(Rcpp::XPtr<ShapeGraph> shapeGraph, const int stepType, const std::vector<double> stepDepthPointsX, const std::vector<double> stepDepthPointsY, const Rcpp::Nullable<int> tulipBinsNV, const Rcpp::Nullable<bool> copyMapNV, const Rcpp::Nullable<bool> verboseNV, const Rcpp::Nullable<bool> progressNV);
RcppExport SEXP _alcyon_segmentStepDepth(SEXP shapeGraphSEXP, SEXP stepTypeSEXP, SEXP stepDepthPointsXSEXP, SEXP stepDepthPointsYSEXP, SEXP tulipBinsNVSEXP, SEXP copyMapNVSEXP, SEXP verboseNVSEXP, SEXP progressNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeGraph> >::type shapeGraph(shapeGraphSEXP);
    Rcpp::traits::input_parameter< const int >::type stepType(stepTypeSEXP);
    Rcpp::traits::input_parameter< const std::vector<double> >::type stepDepthPointsX(stepDepthPointsXSEXP);
    Rcpp::traits::input_parameter< const std::vector<double> >::type stepDepthPointsY(stepDepthPointsYSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<int> >::type tulipBinsNV(tulipBinsNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type verboseNV(verboseNVSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type progressNV(progressNVSEXP);
    rcpp_result_gen = Rcpp::wrap(segmentStepDepth(shapeGraph, stepType, stepDepthPointsX, stepDepthPointsY, tulipBinsNV, copyMapNV, verboseNV, progressNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaThroughVision
Rcpp::List vgaThroughVision(Rcpp::XPtr<PointMap> pointMapPtr, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaThroughVision(SEXP pointMapPtrSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaThroughVision(pointMapPtr, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaAngular
Rcpp::List vgaAngular(Rcpp::XPtr<PointMap> pointMapPtr, double radius, bool gatesOnly, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaAngular(SEXP pointMapPtrSEXP, SEXP radiusSEXP, SEXP gatesOnlySEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< double >::type radius(radiusSEXP);
    Rcpp::traits::input_parameter< bool >::type gatesOnly(gatesOnlySEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaAngular(pointMapPtr, radius, gatesOnly, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaMetric
Rcpp::List vgaMetric(Rcpp::XPtr<PointMap> pointMapPtr, double radius, bool gatesOnly, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaMetric(SEXP pointMapPtrSEXP, SEXP radiusSEXP, SEXP gatesOnlySEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< double >::type radius(radiusSEXP);
    Rcpp::traits::input_parameter< bool >::type gatesOnly(gatesOnlySEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaMetric(pointMapPtr, radius, gatesOnly, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaVisualGlobal
Rcpp::List vgaVisualGlobal(Rcpp::XPtr<PointMap> pointMapPtr, int radius, bool gatesOnly, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaVisualGlobal(SEXP pointMapPtrSEXP, SEXP radiusSEXP, SEXP gatesOnlySEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< int >::type radius(radiusSEXP);
    Rcpp::traits::input_parameter< bool >::type gatesOnly(gatesOnlySEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaVisualGlobal(pointMapPtr, radius, gatesOnly, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaVisualLocal
Rcpp::List vgaVisualLocal(Rcpp::XPtr<PointMap> pointMapPtr, bool gatesOnly, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaVisualLocal(SEXP pointMapPtrSEXP, SEXP gatesOnlySEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< bool >::type gatesOnly(gatesOnlySEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaVisualLocal(pointMapPtr, gatesOnly, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaIsovist
Rcpp::List vgaIsovist(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::XPtr<ShapeMap> shapeMapPtr, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaIsovist(SEXP pointMapPtrSEXP, SEXP shapeMapPtrSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<ShapeMap> >::type shapeMapPtr(shapeMapPtrSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaIsovist(pointMapPtr, shapeMapPtr, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaVisualDepth
Rcpp::List vgaVisualDepth(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::NumericMatrix stepDepthPoints, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaVisualDepth(SEXP pointMapPtrSEXP, SEXP stepDepthPointsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type stepDepthPoints(stepDepthPointsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaVisualDepth(pointMapPtr, stepDepthPoints, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaMetricDepth
Rcpp::List vgaMetricDepth(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::NumericMatrix stepDepthPoints, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaMetricDepth(SEXP pointMapPtrSEXP, SEXP stepDepthPointsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type stepDepthPoints(stepDepthPointsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaMetricDepth(pointMapPtr, stepDepthPoints, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}
// vgaAngularDepth
Rcpp::List vgaAngularDepth(Rcpp::XPtr<PointMap> pointMapPtr, Rcpp::NumericMatrix stepDepthPoints, const Rcpp::Nullable<bool> copyMapNV);
RcppExport SEXP _alcyon_vgaAngularDepth(SEXP pointMapPtrSEXP, SEXP stepDepthPointsSEXP, SEXP copyMapNVSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<PointMap> >::type pointMapPtr(pointMapPtrSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type stepDepthPoints(stepDepthPointsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<bool> >::type copyMapNV(copyMapNVSEXP);
    rcpp_result_gen = Rcpp::wrap(vgaAngularDepth(pointMapPtr, stepDepthPoints, copyMapNV));
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_alcyon_createFromGrid", (DL_FUNC) &_alcyon_createFromGrid, 5},
    {"_alcyon_blockLines", (DL_FUNC) &_alcyon_blockLines, 3},
    {"_alcyon_fill", (DL_FUNC) &_alcyon_fill, 3},
    {"_alcyon_makeGraph", (DL_FUNC) &_alcyon_makeGraph, 4},
    {"_alcyon_unmakeGraph", (DL_FUNC) &_alcyon_unmakeGraph, 3},
    {"_alcyon_pointMapGetName", (DL_FUNC) &_alcyon_pointMapGetName, 1},
    {"_alcyon_pointMapGetLinks", (DL_FUNC) &_alcyon_pointMapGetLinks, 1},
    {"_alcyon_pointMapGetConnections", (DL_FUNC) &_alcyon_pointMapGetConnections, 1},
    {"_alcyon_getGridCoordinates", (DL_FUNC) &_alcyon_getGridCoordinates, 1},
    {"_alcyon_getPointMapAttributeNames", (DL_FUNC) &_alcyon_getPointMapAttributeNames, 1},
    {"_alcyon_getPointMapAttributeData", (DL_FUNC) &_alcyon_getPointMapAttributeData, 2},
    {"_alcyon_getPointMapPropertyData", (DL_FUNC) &_alcyon_getPointMapPropertyData, 2},
    {"_alcyon_getFilledPoints", (DL_FUNC) &_alcyon_getFilledPoints, 1},
    {"_alcyon_getAxialConnections", (DL_FUNC) &_alcyon_getAxialConnections, 1},
    {"_alcyon_getSegmentConnections", (DL_FUNC) &_alcyon_getSegmentConnections, 1},
    {"_alcyon_getLinksUnlinks", (DL_FUNC) &_alcyon_getLinksUnlinks, 1},
    {"_alcyon_make", (DL_FUNC) &_alcyon_make, 1},
    {"_alcyon_getName", (DL_FUNC) &_alcyon_getName, 1},
    {"_alcyon_getShapeMapAttributeNames", (DL_FUNC) &_alcyon_getShapeMapAttributeNames, 1},
    {"_alcyon_getShapeMapAttributeData", (DL_FUNC) &_alcyon_getShapeMapAttributeData, 2},
    {"_alcyon_getShapesAsLineCoords", (DL_FUNC) &_alcyon_getShapesAsLineCoords, 1},
    {"_alcyon_getShapesAsPolygonCoords", (DL_FUNC) &_alcyon_getShapesAsPolygonCoords, 1},
    {"_alcyon_getShapesAsPolylineCoords", (DL_FUNC) &_alcyon_getShapesAsPolylineCoords, 1},
    {"_alcyon_getShapeCoords", (DL_FUNC) &_alcyon_getShapeCoords, 2},
    {"_alcyon_getShapeAttributes", (DL_FUNC) &_alcyon_getShapeAttributes, 2},
    {"_alcyon_agentAnalysis", (DL_FUNC) &_alcyon_agentAnalysis, 14},
    {"_alcyon_makeAllLineMap", (DL_FUNC) &_alcyon_makeAllLineMap, 3},
    {"_alcyon_extractFewestLineMaps", (DL_FUNC) &_alcyon_extractFewestLineMaps, 1},
    {"_alcyon_runAxialAnalysis", (DL_FUNC) &_alcyon_runAxialAnalysis, 8},
    {"_alcyon_runAxialLocalAnalysis", (DL_FUNC) &_alcyon_runAxialLocalAnalysis, 4},
    {"_alcyon_axialStepDepth", (DL_FUNC) &_alcyon_axialStepDepth, 7},
    {"_alcyon_getSfShapeMapExpectedColName", (DL_FUNC) &_alcyon_getSfShapeMapExpectedColName, 2},
    {"_alcyon_getAxialToSegmentExpectedColName", (DL_FUNC) &_alcyon_getAxialToSegmentExpectedColName, 1},
    {"_alcyon_toShapeMap", (DL_FUNC) &_alcyon_toShapeMap, 2},
    {"_alcyon_toAxialShapeGraph", (DL_FUNC) &_alcyon_toAxialShapeGraph, 3},
    {"_alcyon_axialToSegment", (DL_FUNC) &_alcyon_axialToSegment, 4},
    {"_alcyon_shapeMapToSegment", (DL_FUNC) &_alcyon_shapeMapToSegment, 5},
    {"_alcyon_makeIsovists", (DL_FUNC) &_alcyon_makeIsovists, 5},
    {"_alcyon_shapeGraphLinkCoords", (DL_FUNC) &_alcyon_shapeGraphLinkCoords, 3},
    {"_alcyon_shapeGraphLinkRefs", (DL_FUNC) &_alcyon_shapeGraphLinkRefs, 3},
    {"_alcyon_pointMapLinkCoords", (DL_FUNC) &_alcyon_pointMapLinkCoords, 3},
    {"_alcyon_pointMapLinkRefs", (DL_FUNC) &_alcyon_pointMapLinkRefs, 3},
    {"_alcyon_shapeMapUnlinkCoords", (DL_FUNC) &_alcyon_shapeMapUnlinkCoords, 3},
    {"_alcyon_shapeGraphUnlinkAtCrossPoint", (DL_FUNC) &_alcyon_shapeGraphUnlinkAtCrossPoint, 3},
    {"_alcyon_shapeMapUnlinkRefs", (DL_FUNC) &_alcyon_shapeMapUnlinkRefs, 3},
    {"_alcyon_pointMapUnlinkCoords", (DL_FUNC) &_alcyon_pointMapUnlinkCoords, 3},
    {"_alcyon_pointMapUnlinkRefs", (DL_FUNC) &_alcyon_pointMapUnlinkRefs, 3},
    {"_alcyon_readMetaGraph", (DL_FUNC) &_alcyon_readMetaGraph, 2},
    {"_alcyon_runSegmentAnalysis", (DL_FUNC) &_alcyon_runSegmentAnalysis, 11},
    {"_alcyon_segmentStepDepth", (DL_FUNC) &_alcyon_segmentStepDepth, 8},
    {"_alcyon_vgaThroughVision", (DL_FUNC) &_alcyon_vgaThroughVision, 2},
    {"_alcyon_vgaAngular", (DL_FUNC) &_alcyon_vgaAngular, 4},
    {"_alcyon_vgaMetric", (DL_FUNC) &_alcyon_vgaMetric, 4},
    {"_alcyon_vgaVisualGlobal", (DL_FUNC) &_alcyon_vgaVisualGlobal, 4},
    {"_alcyon_vgaVisualLocal", (DL_FUNC) &_alcyon_vgaVisualLocal, 3},
    {"_alcyon_vgaIsovist", (DL_FUNC) &_alcyon_vgaIsovist, 3},
    {"_alcyon_vgaVisualDepth", (DL_FUNC) &_alcyon_vgaVisualDepth, 3},
    {"_alcyon_vgaMetricDepth", (DL_FUNC) &_alcyon_vgaMetricDepth, 3},
    {"_alcyon_vgaAngularDepth", (DL_FUNC) &_alcyon_vgaAngularDepth, 3},
    {NULL, NULL, 0}
};

RcppExport void R_init_alcyon(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
