% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale_ixn.R
\name{ale_ixn}
\alias{ale_ixn}
\title{ale_ixn.R}
\usage{
ale_ixn(
  test_data,
  model,
  x1_cols = NULL,
  x2_cols = NULL,
  output = c("plot", "data"),
  pred_fun = function(object, newdata) {
     stats::predict(object = object, newdata =
    newdata, type = predict_type)
 },
  predict_type = "response",
  x_intervals = 100,
  boot_it = 0,
  boot_alpha = 0.05,
  boot_centre = "median",
  relative_y = "median",
  y_type = NULL,
  plot_alpha = 0.05,
  ale_xs = NULL,
  n_x1_int = 20,
  n_x2_int = 20,
  n_y_quant = 10
)
}
\arguments{
\item{test_data}{See documentation for \code{ale}}

\item{model}{See documentation for \code{ale}}

\item{x1_cols, x2_cols}{character. Vectors of column names from \code{test_dataset} for which
two-way interaction ALE data is to be calculated. ALE data will be calculated
for each x1 column interacting with each x2 column. x1_cols can be of any standard
datatype (logical, factor, or numeric) but x2_cols can only be numeric. If
\code{ixn} is TRUE, then both values must be provided.}

\item{output}{See documentation for \code{ale}}

\item{pred_fun, predict_type}{See documentation for \code{ale}}

\item{x_intervals}{See documentation for \code{ale}}

\item{boot_it}{See documentation for \code{ale}}

\item{boot_alpha}{See documentation for \code{ale}}

\item{boot_centre}{See documentation for \code{ale}}

\item{relative_y}{See documentation for \code{ale}}

\item{y_type}{See documentation for \code{ale}}

\item{plot_alpha}{See documentation for \code{ale}}

\item{ale_xs}{See documentation for \code{ale}}

\item{n_x1_int, n_x2_int}{non-negative integer. Number of intervals
for the x1 or x2 axes respectively for interaction plot. These values are
ignored if x1 or x2 are not numeric (i.e, if they are logical or factors).}

\item{n_y_quant}{positive integer. which the range
of y values is divided for the colour bands of the interaction plot. See details.}
}
\value{
list of ALE interaction data tibbles and plots.
The list has two levels of depth:
\itemize{
\item The first level is named by the x1 variables.
\item Within each x1 variable list, the second level is named by the x2 variables.
\item Within each x1-x2 list element, the data or plot is returned as requested in
the \code{output} argument.
}
}
\description{
ALE interaction plots modified and extended from \code{ALEPlot::ALEPlot}.
}
\details{
Create and return ALE interaction data and plots

This is the central function that manages the creation of ALE data and plots
for two-way ALE interactions. For simple one-way ALE, see \code{ale}.
See documentation there for functionality shared between both functions.
This function calls \code{ale_core} that manages the ALE data and plot creation in detail.
For details, see
the introductory vignette for this package or the details and examples below.

\code{n_y_quant} is the number of quantiles into which to
divide the predicted variable (y). The middle quantiles are grouped specially:
\itemize{
\item The middle quantile is the \code{plot_alpha} confidence interval around the median.
This middle quantile is special because it generally represents no meaningful
interaction.
\item The quantiles above and below the middle are extended from the borders of
the middle quantile to the regular borders of the other quantiles.
}

There will always be an odd number of quantiles: the special middle quantile
plus an equal number of quantiles on each side of it. If n_y_quant is even,
then a middle quantile will be added to it. If n_y_quant is odd, then the
number specified will be used, including the middle quantile.
}
\examples{

diamonds
set.seed(0)
diamonds_sample <- diamonds[sample(nrow(diamonds), 1000), ]

# Split the dataset into training and test sets
# https://stackoverflow.com/a/54892459/2449926
set.seed(0)
train_test_split <- sample(
  c(TRUE, FALSE), nrow(diamonds_sample), replace = TRUE, prob = c(0.8, 0.2)
)
diamonds_train <- diamonds_sample[train_test_split, ]
diamonds_test <- diamonds_sample[!train_test_split, ]


# Create a GAM model with flexible curves to predict diamond price
# Smooth all numeric variables and include all other variables
# Build model on training data, not on the full dataset.
gam_diamonds <- mgcv::gam(
  price ~ s(carat) + s(depth) + s(table) + s(x) + s(y) + s(z) +
    cut + color + clarity,
  data = diamonds_train
)
summary(gam_diamonds)

# ALE two-way interactions
ale_ixn_gam_diamonds <- ale_ixn(diamonds_test, gam_diamonds)


\donttest{
# Skip .common_data when iterating through the data for plotting
ale_ixn_gam_diamonds[setdiff(names(ale_ixn_gam_diamonds), '.common_data')] |>
  purrr::walk(\(x1) {  # extract list of x1 ALE outputs
    purrr::map(x1, \(.x) .x$plot) |>  # for each x1, extract list of x2 ALE outputs
      gridExtra::grid.arrange(grobs = _, ncol = 2)  # plot all x1 plots
  })
}


}
