% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/alleLoader.R
\name{alleLoader}
\alias{alleLoader}
\title{Data loading of nuclear families (in .ped format)}
\usage{
alleLoader(data, invisibleOutput = TRUE, dataSummary = TRUE)
}
\arguments{
\item{data}{Data to be loaded.}

\item{invisibleOutput}{Data are not shown by default.}

\item{dataSummary}{A summary of the data is shown by default.}
}
\value{
Loaded dataset.
}
\description{
The data to be loaded must be structured in .ped format and families must comprise by parent-offspring pedigrees.
}
\examples{
## Loading of a dataset in .ped format with alphabetical alleles (A,C,G,T)
example1 <- file.path(find.package("alleHap"), "examples", "example1.ped")
example1Alls <- alleLoader(example1)
head(example1Alls)

## Loading of a dataset in .ped format with numerical alleles
example2 <- file.path(find.package("alleHap"), "examples", "example2.ped")
example2Alls <- alleLoader(example2)
head(example2Alls)
}
\references{
Medina-Rodriguez, N. Santana A. et al. (2014) alleHap: an efficient algorithm to reconstruct zero-recombinant haplotypes from parent-offspring pedigrees. BMC Bioinformatics, 15, A6 (S-3).
}

