% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_koppen_geiger}
\alias{calc_koppen_geiger}
\title{Calculate climate classification covariates}
\usage{
calc_koppen_geiger(
  from = NULL,
  locs = NULL,
  locs_id = "site_id",
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{process_koppen_geiger()}.}

\item{locs}{sf/SpatVector. Unique locs. Should include
a unique identifier field named \code{locs_id}}

\item{locs_id}{character(1). Name of unique identifier.}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Extract climate classification values at point locations. Returns a
\code{data.frame} object containing \code{locs_id} and
binary (0 = point not in climate region; 1 = point in climate region)
variables for each climate classification region.
}
\note{
The returned object contains a
\verb{$description} column to represent the temporal range covered by the
dataset. For more information, see
\url{https://www.nature.com/articles/sdata2018214}.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calc_koppen_geiger(
  from = kg, # derived from process_koppen_geiger() example
  locs = loc,
  locs_id = "id",
  geom = FALSE
)
}
}
\seealso{
\code{\link{process_koppen_geiger}}
}
\author{
Insang Song
}
