% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_terraclimate}
\alias{calculate_terraclimate}
\title{Calculate TerraClimate covariates}
\usage{
calculate_terraclimate(
  from = NULL,
  locs = NULL,
  locs_id = NULL,
  radius = 0,
  fun = "mean",
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatRaster(1). Output from \code{process_terraclimate()}.}

\item{locs}{data.frame. character to file path, SpatVector, or sf object.}

\item{locs_id}{character(1). Column within \code{locations} CSV file
containing identifier for each unique coordinate location.}

\item{radius}{integer(1). Circular buffer distance around site locations.
(Default = 0).}

\item{fun}{character(1). Function used to summarize multiple raster cells
within sites location buffer (Default = \code{mean}).}

\item{geom}{FALSE/"sf"/"terra".. Should the function return with geometry?
Default is \code{FALSE}, options with geometry are "sf" or "terra". The
coordinate reference system of the \code{sf} or \code{SpatVector} is that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Extract TerraClimate values at point locations. Returns a \code{data.frame}
object containing \code{locs_id} and TerraClimate variable. TerraClimate
variable column name reflects the TerraClimate variable and
circular buffer radius.
}
\note{
TerraClimate data has monthly temporal resolution, so the \verb{$time} column
will contain the year and month in YYYYMM format (ie. January, 2018 =
201801).
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_terraclimate(
  from = terraclimate, # derived from process_terraclimate() example
  locs = loc,
  locs_id = "id",
  radius = 0,
  fun = "mean",
  geom = FALSE
)
}
}
\seealso{
\code{\link[=process_terraclimate]{process_terraclimate()}}
}
\author{
Mitchell Manware
}
