% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates_auxiliary.R
\name{calc_setcolumns}
\alias{calc_setcolumns}
\title{Set column names}
\usage{
calc_setcolumns(from, lag, dataset, locs_id)
}
\arguments{
\item{from}{data.frame(1) or SpatVector(1). Calculated covariates as
returned from \code{calc_covariates()} or a source specific covariate
function.}

\item{lag}{integer(1). Temporal lag.}

\item{dataset}{character(1). Covariate parent dataset.}

\item{locs_id}{character(1). Column containing identifier for each unique
coordinate location.}
}
\value{
a data.frame or SpatVector object (depending on \code{from})
}
\description{
Apply standard column names to calculated covariates consistent with
the requirements of the \code{beethoven} package. Column names follow fixed
format of 3 character data genre, 2 - 15 character variable code, 1 digit
temporal lag, and 5 digit buffer radius (in meters). Variable code character
range is required to retain interpretable column names across datasets.
}
\note{
\code{beethoven} utilizes point, 1km, and 10km radius buffer distance for
covariate calculation, and therefore the buffer radius column is
padded to 5 digits. If provided a buffer radius greater than 5 digits,
\code{calc_setcolumns()} will expand to the number of digits. (ie. buffer
radius of 100km = CCC_CCCCC_I_100000).
}
\keyword{auxiliary}
\keyword{internal}
