% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MASV.AMMI.R
\name{MASV.AMMI}
\alias{MASV.AMMI}
\title{Modified AMMI Stability Value}
\usage{
MASV.AMMI(model, n, alpha = 0.05, ssi.method = c("farshadfar", "rao"), a = 1)
}
\arguments{
\item{model}{The AMMI model (An object of class \code{AMMI} generated by
\code{\link[agricolae]{AMMI}}).}

\item{n}{The number of principal components to be considered for computation.
The default value is the number of significant IPCs.}

\item{alpha}{Type I error probability (Significance level) to be considered
to identify the number of significant IPCs.}

\item{ssi.method}{The method for the computation of simultaneous selection
index. Either \code{"farshadfar"} or \code{"rao"} (See
\code{\link[ammistability]{SSI}}).}

\item{a}{The ratio of the weights given to the stability components for
computation of SSI when \code{method = "rao"} (See
\code{\link[ammistability]{SSI}}).}
}
\value{
A data frame with the following columns:  \item{MASV}{The MASV
  values.} \item{SSI}{The computed values of simultaneous selection index for
  yield and stability.} \item{rMASV}{The ranks of MASV values.} \item{rY}{The
  ranks of the mean yield of genotypes.} \item{means}{The mean yield of the
  genotypes.}

  The names of the genotypes are indicated as the row names of the data
  frame.
}
\description{
\code{MASV.AMMI} computes the Modified AMMI Stability Value (MASV)
\insertCite{zali_evaluation_2012,ajay_rectification_2019}{ammistability}
(Please see \strong{Note}) from a modified formula of AMMI Stability Value
(ASV) \insertCite{purchase_parametric_1997}{ammistability}. This formula
calculates AMMI stability value considering all significant interaction
principal components (IPCs) in the AMMI model. Using MASV, the Simultaneous
Selection Index for Yield and Stability (SSI) is also calculated according to
the argument \code{ssi.method}. \loadmathjax
}
\details{
The Modified AMMI Stability Value (\mjseqn{MASV})
\insertCite{ajay_rectification_2019}{ammistability} is computed as follows:

\mjsdeqn{MASV = \sqrt{\sum_{n=1}^{N'-1}\left (\frac{SSIPC_{n}}{SSIPC_{n+1}}
\times PC_{n} \right )^2   + \left (PC_{N'}  \right )^2}}

Where, \mjseqn{SSIPC_{1}}, \mjseqn{SSIPC_{2}}, \mjseqn{\cdots},
\mjseqn{SSIPC_{n}} are the sum of squares of the 1st, 2nd, ..., and
\mjseqn{n}th IPC; and \mjseqn{PC_{1}}, \mjseqn{PC_{2}}, \mjseqn{\cdots},
\mjseqn{PC_{n}} are the scores of 1st, 2nd, ..., and \mjseqn{n}th IPC.
}
\note{
In \insertCite{zali_evaluation_2012;textual}{ammistability}, the
  formula for both AMMI stability value (ASV) was found to be erroneous, when
  compared with the original publications
  \insertCite{purchase_parametric_1997,purchase_use_1999,purchase_genotype_2000}{ammistability}.


  \strong{ASV \insertCite{zali_evaluation_2012}{ammistability}} \mjsdeqn{ASV
  = \sqrt{\left ( \frac{SSIPC_{1}}{SSIPC_{2}} \right ) \times (PC_{1})^2   +
  \left (PC_{2} \right )^2}}

  \strong{ASV
  \insertCite{purchase_parametric_1997,purchase_use_1999,purchase_genotype_2000}{ammistability}}
   \mjsdeqn{ASV = \sqrt{\left (\frac{SSIPC_{1}}{SSIPC_{2}} \times PC_{1}
  \right )^2   + \left (PC_{2} \right )^2}}

  The authors believe that the proposed Modified AMMI stability value (MASV)
  in \insertCite{zali_evaluation_2012;textual}{ammistability} is also
  erroneous and have implemented the corrected one in \code{MASV.AMMI}
  \insertCite{ajay_rectification_2019}{ammistability}.

  \strong{MASV \insertCite{zali_evaluation_2012}{ammistability}}
  \mjsdeqn{MASV = \sqrt{\sum_{n=1}^{N'-1}\left (
  \frac{SSIPC_{n}}{SSIPC_{n+1}} \right ) \times (PC_{n})^2   + \left (PC_{N'}
  \right )^2}}
}
\examples{
library(agricolae)
data(plrv)

# AMMI model
model <- with(plrv, AMMI(Locality, Genotype, Rep, Yield, console = FALSE))

# ANOVA
model$ANOVA

# IPC F test
model$analysis

# Mean yield and IPC scores
model$biplot

# G*E matrix (deviations from mean)
array(model$genXenv, dim(model$genXenv), dimnames(model$genXenv))

# With default n (N') and default ssi.method (farshadfar)
MASV.AMMI(model)

# With n = 4 and default ssi.method (farshadfar)
MASV.AMMI(model, n = 4)

# With default n (N') and ssi.method = "rao"
MASV.AMMI(model, ssi.method = "rao")

# Changing the ratio of weights for Rao's SSI
MASV.AMMI(model, ssi.method = "rao", a = 0.43)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[agricolae]{AMMI}}, \code{\link[agricolae]{index.AMMI}},
  \code{\link[ammistability]{SSI}}
}
