% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uhc_plots.R
\name{conf_envelope}
\alias{conf_envelope}
\title{Create confidence envelopes from a \code{uhc_data_frame}}
\usage{
conf_envelope(x, levels = c(0.95, 1))
}
\arguments{
\item{x}{\verb{[uhc_data]} An object of class \code{uhc_data_frame}, as returned
by the function \code{\link{as.data.frame.uhc_data}()}.}

\item{levels}{\verb{[numeric]} A numeric vector specifying the desired confidence
levels. Defaults to \code{c(0.95, 1)} to create 95\% and 100\% confidence intervals.}
}
\value{
Returns a \code{data.frame} with columns:
\itemize{
\item \code{var}: The name of the variable
\item \code{x}: The x-coordinate of the density plot (the value of \code{var}).
\item \code{label}: If \code{var} is a \code{factor}, the label for the value given by \code{x}.
\item \code{U}: The y-coordinate of the density plot for the use distribution.
\item \code{A}: The y-coordinate of the density plot for the availability distribution.
\item \verb{CI*_lwr}: The lower bound of the confidence envelope for the corresponding
confidence level.
\item \verb{CI*_upr}: The upper bound of the confidence envelope for the corresponding
confidence level.
}
}
\description{
Simplifies sampled distributions in a \code{uhc_data_frame} to confidence envelopes
}
\details{
This can dramatically improve plotting time for UHC plots by
simplifying the many sampled lines down to the boundaries of a polygon.
}
\seealso{
\code{\link{prep_uhc}()}, \code{\link{plot.uhc_envelopes}()}
}
\author{
Brian J. Smith
}
