% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbox.R
\name{bbox}
\alias{bbox}
\alias{bbox.track_xy}
\alias{bbox.steps_xy}
\title{Get bounding box of a track.}
\usage{
bbox(x, ...)

\method{bbox}{track_xy}(x, spatial = TRUE, buffer = NULL, ...)

\method{bbox}{steps_xy}(x, spatial = TRUE, buffer = NULL, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented.}

\item{spatial}{\verb{[logical(1)=TRUE]} \cr Whether or not to return an object of class \code{sf-Polygon}-object or not.}

\item{buffer}{\verb{[numeric(0)=NULL]\{NULL, >0\}} \cr An optional buffer of the bounding box.}
}
\value{
If \code{spatial = FALSE} a named vector of length four with the extent of the bounding box. Otherwise a \code{SpatialPolygon} or a simple freature polygon with the bounding box.
}
\description{
Get bounding box of a track.
}
\examples{
data(deer)
bbox(deer)
bbox(deer, spatial = FALSE)
bbox(deer, buffer = 100, spatial = FALSE)

# For steps
deer |> steps_by_burst() |> bbox(spatial = FALSE)
deer |> steps_by_burst() |> bbox(buffer = 100, spatial = FALSE)
deer |> steps_by_burst() |> random_steps() |> bbox(spatial = FALSE)

# Further manipulations are possible
deer |> bbox() |> sf::st_transform(4326)
}
