% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubuntu.R
\name{ubuntu}
\alias{ubuntu}
\alias{ubuntu_add_swap}
\alias{ubuntu_install_r}
\alias{ubuntu_install_rstudio}
\alias{ubuntu_install_shiny}
\alias{ubuntu_apt_get_cran}
\alias{ubuntu_apt_get_update}
\alias{ubuntu_apt_get_install}
\alias{install_r_package}
\alias{install_github_r_package}
\alias{ubuntu_create_user}
\title{Helpers for managing a ubuntu droplets.}
\usage{
ubuntu_add_swap(
  droplet,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

ubuntu_install_r(
  droplet,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE,
  rprofile = "options(repos=c('CRAN'='https://cloud.r-project.org/'))"
)

ubuntu_install_rstudio(
  droplet,
  user = "rstudio",
  password = "server",
  version = "0.99.484",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

ubuntu_install_shiny(
  droplet,
  version = "1.4.0.756",
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE,
  rprofile = "options(repos=c('CRAN'='https://cloud.r-project.org/'))"
)

ubuntu_apt_get_cran(
  droplet,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

ubuntu_apt_get_update(
  droplet,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

ubuntu_apt_get_install(
  droplet,
  ...,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

install_r_package(
  droplet,
  package,
  repo = "https://cloud.r-project.org/",
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

install_github_r_package(
  droplet,
  package,
  repo = "https://cloud.r-project.org/",
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

ubuntu_create_user(
  droplet,
  user,
  password,
  ssh_user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)
}
\arguments{
\item{droplet}{A droplet, or object that can be coerced to a droplet
by \code{\link{as.droplet}}.}

\item{user}{Username for non-root account.}

\item{keyfile}{Optional private key file.}

\item{ssh_passwd}{Optional passphrase or callback function for authentication.
Refer to the \code{ssh::ssh_connect} documentation for more
details.}

\item{verbose}{If TRUE, will print command before executing it.}

\item{rprofile}{A character string that will be added to the .Rprofile}

\item{password}{Password for non-root account.}

\item{version}{Version of rstudio to install.}

\item{...}{Arguments to apt-get install.}

\item{package}{Name of R package to install.}

\item{repo}{CRAN mirror to use.}

\item{ssh_user}{(character) User account for ssh commands against droplet.}
}
\description{
Helpers for managing a ubuntu droplets.
}
\examples{
\dontrun{
d <- droplet_create()
d \%>\% ubuntu_add_swap()
d \%>\% ubuntu_apt_get_update()

d \%>\% ubuntu_install_r()
d \%>\% ubuntu_install_rstudio()

# Install libcurl, then build RCurl from source
d \%>\% ubuntu_apt_get_install("libcurl4-openssl-dev")
d \%>\% install_r_package("RCurl")
droplet_delete(d)
}
}
