% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapping.R
\name{bootstrapped_difference_pvalues}
\alias{bootstrapped_difference_pvalues}
\title{To obtain two non-overlapping bootstrapped versions and obtain p-values for the significance of difference between them}
\usage{
bootstrapped_difference_pvalues(
  network,
  n_versions = 1000,
  seed = 12345,
  n.iter = 10,
  network_metrics = c("mean_degree", "mean_strength", "density", "diameter",
    "transitivity")
)
}
\arguments{
\item{network}{An igraph object}

\item{n_versions}{Number of bootstrapped versions to be used}

\item{seed}{seed number}

\item{n.iter}{Number of iterations at each level}

\item{network_metrics}{Network metrics to be evaluated. This should be supplied as a character vector and the values 
should be chosen from "mean_degree", "mean_strength", "density", "diameter", "transitivity". (default = c("mean_degree", "mean_strength", "density", "diameter", "transitivity")).}
}
\value{
A matrix of p-values whose rows correspond to the sub-sample size and columns correspond to the chosen network metric.
}
\description{
To obtain two non-overlapping bootstrapped versions and obtain p-values for the significance of difference between them
}
\examples{
\donttest{
data(elk_network_2010)
bootstrapped_difference_pvalues(elk_network_2010, n_versions = 100)
}
}
