% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capa.R, R/capa.mv.R, R/capa.uv.R, R/scapa.mv.R,
%   R/scapa.uv.R
\docType{methods}
\name{point_anomalies}
\alias{point_anomalies}
\alias{point_anomalies,capa.class-method}
\alias{point_anomalies,capa.mv.class-method}
\alias{point_anomalies,capa.uv.class-method}
\alias{point_anomalies,scapa.mv.class-method}
\alias{point_anomalies,scapa.uv.class-method}
\title{Point anomaly location and strength.}
\usage{
\S4method{point_anomalies}{capa.class}(object, epoch = nrow(object@data))

\S4method{point_anomalies}{capa.mv.class}(object)

\S4method{point_anomalies}{capa.uv.class}(object)

\S4method{point_anomalies}{scapa.mv.class}(object, epoch = nrow(object@data))

\S4method{point_anomalies}{scapa.uv.class}(object, epoch = nrow(object@data))
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{capa}}, \code{\link{capa.uv}}, and \code{\link{capa.mv}}.}

\item{epoch}{Positive integer. CAPA methods are sequential and as such, can generate results up to, and including, any epoch within the data series. This can be controlled by the value
of \code{epoch} and is useful for examining how the inferred anomalies are modified as the data series grows. The default value for \code{epoch} is the length of the data series.}
}
\value{
A data frame.
}
\description{
Creates a data frame containing point anomaly locations and strengths as detected by \code{\link{capa}}, \code{\link{capa.uv}}, \code{\link{capa.mv}}, \code{\link{scapa.uv}}, and \code{\link{scapa.mv}}.


For an object produced by \code{\link{capa.uv}} or \code{\link{scapa.uv}}, the output is a data frame  with columns containing the position and
strength of the anomaly. 

For an object produced by \code{\link{capa.mv}} or \code{\link{capa.mv}}, \code{point_anomalies} returns a data frame with columns containing the position, variate, and
strength of the anomaly. 


For an object produced by \code{\link{capa}}, \code{point_anomalies} returns the same results as \code{\link{scapa.uv}} when the data is univariate, and the same results as
\code{\link{scapa.mv}} when the data is multivariate.
}
\seealso{
\code{\link{capa}}, \code{\link{capa.uv}}, \code{\link{capa.mv}}.
}
