% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmat.R
\name{hmat}
\alias{hmat}
\title{Plot a Histogram Matrix}
\usage{
hmat(data, input = "data", top = 20, order = "numeric",
  block_length = NULL, level_limit = 50, level_keep = 10,
  partial_block = TRUE, na.rm = FALSE, min_var = 0.1, max_cor = 0.9,
  action = "exclude", output = "both", normalize = FALSE)
}
\arguments{
\item{data}{the data set (data frame or matrix)}

\item{input}{the type of input data being passed to the function. \code{data} for
a raw categorical data set, \code{SV} for a state vector input, and \code{MD} if the
input has already had the Mahalanobis distances calculated}

\item{top}{how many of the most anomalous blocks you would like to display
(default 20)}

\item{order}{whether to show the anomalous blocks in numeric order or in order of
most anomalous to least anomalous (default is "numeric", other choice is "anomaly")}

\item{block_length}{argument fed into \code{tabulate_state_vector}, necessary if
\code{input = data}}

\item{level_limit}{argument fed into \code{tabulate_state_vector}, if the
number of unique categories for a variable exceeds this number, only keep
a limited number of the most popular values (default 50)}

\item{level_keep}{argument fed into \code{tabulate_state_vector}, if \code{level_limit}
is exceeded, keep this many of the most popular values (default 10)}

\item{partial_block}{argument fed into \code{tabulate_state_vector}, if the number of
entries is not divisible by the \code{block_length}, this logical decides
whether to keep the smaller last block (default \code{TRUE})}

\item{na.rm}{whether to keep track of missing values as part of the analysis or
ignore them (default \code{FALSE})}

\item{min_var}{argument fed into \code{mc_adjust}, if a column in the state
vector has variance less than this value, remove it (default 0.1)}

\item{max_cor}{argument fed into \code{mc_adjust}, if a column in the state
vector has correlation greater than this value, remove it (default 0.9)}

\item{action}{argument fed into \code{mc_adjust}, if a column does not fall in
the specified range, determine what to do with it (default "exclude")}

\item{output}{argument fed into \code{mahalanobis_distance} that decides
whether to add a column for the Mahalanobis Distance ('MD'), the breakdown
distances ('BD') or both (default "both")}

\item{normalize}{argument fed into \code{mahalanobis_distance} that decides
whether to normalize the values by column (default = FALSE)}
}
\description{
Display a histogram matrix for visual inspection of anomalous
observation detection. The color of the blocks represents how anomalous each
block is, where a lighter blue represents a more anomalous block. The size
of the points indicate which values are driving the anomaly, with larger
blocks representing more anomalous values.
}
\examples{
\dontrun{
# Data set input
hmat(security_logs,block_length = 8)

# Data Set input with top 10 blocks displayed
hmat(security_logs, top = 10, block_length = 5)

# State Vector Input
tabulate_state_vector(security_logs, block_length = 6, level_limit = 20) \%>\%
  hmat(input = "SV")
}

}
