% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savePlotAsPng.R
\name{savePlotAsPng}
\alias{savePlotAsPng}
\title{Save interactive plot as a png image}
\usage{
savePlotAsPng(plot, file = "Rplot.png", width = 600, height = 480, ...)
}
\arguments{
\item{plot}{A plot generated with one of the functions of this package.}

\item{file}{The name of the output file}

\item{width}{Width of the output file}

\item{height}{height of the output file}

\item{...}{Other parameters passed to function [webshot::webshot]}
}
\value{
The function only creates the required file. Nothing is returned
}
\description{
This function saves an interactive plot generated with one of the functions of
this package as a png image. The result can then be included in documents or
presentations.
}
\examples{
\dontrun{
  mydata <- readAntares()
  myplot <- plot(mydata, variable = "MRG. PRICE", type = "density")
  savePlotAsPng(myplot, file = "myplot.png")
}

}
