% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BertrandClasses.R
\docType{class}
\name{BertrandOther-Classes}
\alias{BertrandOther-Classes}
\alias{Bertrand-class}
\alias{Linear-class}
\alias{LogLin-class}
\alias{AIDS-class}
\alias{PCAIDS-class}
\alias{PCAIDSNests-class}
\title{\dQuote{Bertrand} Classes}
\description{
The \dQuote{Bertrand} class is a building block used to create other classes
in this package. As such, it is most likely to be useful for developers
who wish to code their own merger calibration/simulation routines.

Each class below contains all the information needed to calibrate a specific type of demand system and
perform a merger simulation analysis under the assumption that firms are playing a differentiated products Bertrand pricing game.

The \dQuote{Linear} class has the information for a Linear demand system.

The \dQuote{LogLin} class has the information for a Log-Linear demand system.

The \dQuote{AIDS} class has the information for a AIDS demand system.

The \dQuote{PCAIDS} class has the information for a PCAIDS demand system

The \dQuote{PCAIDSNests} class has the information for a nested PCAIDS demand system

Below, let k denote the number of products produced by all firms.
}
\section{Slots}{

\describe{
\item{\code{shares}}{A length k vector containing observed output. Depending upon the model, output will be measured in
units sold, quantity shares, or revenue shares.}

\item{\code{mcDelta}}{A length k vector where each element equals the proportional change in a product's marginal costs due to the merger.}

\item{\code{slopes}}{A k x (k+1) matrix of linear demand intercepts and slope coefficients}

\item{\code{subset}}{A vector of length k where each element equals TRUE if the product indexed by that element should be included in the
post-merger simulation and FALSE if it should be excluded.}

\item{\code{intercepts}}{A length k vector of demand intercepts. (Linear only)}

\item{\code{prices}}{A length k vector product prices. (Linear only)}

\item{\code{quantities}}{A length k vector of product quantities. (Linear only)}

\item{\code{margins}}{A length k vector of product margins. All margins must be between 0 and 1. (Linear only)}

\item{\code{diversion}}{A k x k matrix of diversion ratios with diagonal elements equal to -1.}

\item{\code{priceStart}}{A length k vector of prices used as the initial guess in the nonlinear equation solver. (Linear and AIDS only)}

\item{\code{symmetry}}{If TRUE, requires the matrix of demand slope coefficients to be consistent with utility maximization theory.
Default is false. (Linear and LogLin only)}

\item{\code{insideSize}}{A positive number equal to total pre-merger revenues for all products included in the simulation. (AIDS only)}

\item{\code{mktElast}}{A negative number equal to the industry pre-merger price elasticity. (AIDS only)}

\item{\code{parmStart}}{A length 2 vector who elements equal to an initial of a single diagonal element of the matrix of slope coefficients,
as well as the market elasticity. (AIDS only)}

\item{\code{priceDelta}}{A length k vector containing the simulated price effects from the merger. (AIDS only)}

\item{\code{knownElast}}{A negative number equal to the pre-merger own-price elasticity for any of the k products. (PCAIDS only)}

\item{\code{knownElastIndex}}{An integer equal to the position of the `knownElast' product in the \sQuote{shares} vector. (PCAIDS only)}

\item{\code{nests}}{A length k vector identifying which nest a product belongs to. (Nested PCAIDS only)}

\item{\code{nestsParms}}{A length k vector containing nesting parameters. (Nested PCAIDS only)}
}}

\section{Objects from the Class}{

For Bertrand, objects can be created by calls of the form \code{new("Bertrand", ...)}.

For Linear, objects can be created by using the constructor function \code{\link{linear}}.

For LogLin, objects can be created by using the constructor function \code{\link{loglin}}.

For AIDS, objects can be created by using the constructor function \code{\link{aids}}.

For PCAIDS, objects can be created by using the constructor \code{\link{pcaids}}.

For nested PCAIDS, objects can be created by using the constructor \code{\link{pcaids.nests}}.
}

\section{Extends}{

Bertrand: Class \code{\linkS4class{Antitrust}}, directly.

Linear: Class \code{\linkS4class{Bertrand}}, directly.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 2.

LogLin: Class \code{\linkS4class{Linear}}, directly.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Linear}}, distance 2.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 3.

AIDS: Class \code{\linkS4class{Linear}}, directly. Class \code{\linkS4class{Bertrand}}, by class \dQuote{Linear}, distance 2.

PCAIDS: Class \code{\linkS4class{AIDS}}, directly. Class \code{\linkS4class{Linear}}, by class \code{\linkS4class{AIDS}}, distance 2.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Linear}}, distance 3. Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 4.

Nested PCAIDS: Class \code{\linkS4class{PCAIDS}}, directly. Class \code{\linkS4class{AIDS}}, by class \code{\linkS4class{PCAIDS}}, distance 2.
Class \code{\linkS4class{Linear}}, by class \code{\linkS4class{AIDS}}, distance 3. Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Linear}}, distance 4.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 5.
}

\examples{
showClass("Bertrand")           # get a detailed description of the class
showClass("Linear")           # get a detailed description of the class
showClass("LogLin")           # get a detailed description of the class
showClass("AIDS")           # get a detailed description of the class
showClass("PCAIDS")           # get a detailed description of the class
showClass("PCAIDSNests")           # get a detailed description of the class
}
\author{
Charles Taragin \email{ctaragin+antitrustr@gmail.com}
}
\keyword{classes}
